<JSB>
/*
 * DBSelect.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.DBSelect" DISPLAYNAME="DBSelect" ISHIDDEN ENV="both"
        SHORTDESCRIPTION="Database populated Select Box"  VISUAL="netscape.palomar.page.component.HTMLSelect">

    <JSB_PROPERTY NAME="dbpool" DISPLAYNAME="dbPool" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Name of LiveWire DBPool object to operate on">

    <JSB_PROPERTY NAME="table" DISPLAYNAME="table" ISRUNTIME PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="table from which to get values">

    <JSB_PROPERTY NAME="textColumn" DISPLAYNAME="textColumn" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Column from which to get display choices">

    <JSB_PROPERTY NAME="textExpr" DISPLAYNAME="Text Expression" PROPTYPE="JS" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Expression for List Item Texts">

    <JSB_PROPERTY NAME="valueColumn" DISPLAYNAME="valueColumn" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Column from which to get value">

    <JSB_PROPERTY NAME="defaultValue" DISPLAYNAME="default value" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Value of option which is initially selected">

    <JSB_PROPERTY NAME="multiple" DISPLAYNAME="Multiple Selection" PROPTYPE="JS" TYPE="boolean" ENV="server"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to allow mulitple list items to be selected.">

    <JSB_PROPERTY NAME="filterCol" DISPLAYNAME="Filter Column" ISRUNTIME PROPTYPE="JS-expr" TYPE="string" ENV="server"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of column to filter on by value passed in request object">

    <JSB_PROPERTY NAME="sortCol" DISPLAYNAME="Sort Column" ISRUNTIME PROPTYPE="JS-expr" TYPE="string" ENV="server"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Column to sort data on">

    <JSB_PROPERTY NAME="sortAscending" DISPLAYNAME="Sort direction" ISRUNTIME PROPTYPE="JS-expr" TYPE="boolean" ENV="server"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Sort direction: TRUE = Ascending; FALSE = Descending">

    <JSB_PROPERTY NAME="release" DISPLAYNAME="Release Connection" PROPTYPE="JS" TYPE="boolean" ENV="server"
        READMETHOD="" WRITEMETHOD="" DEFAULT_VALUE="true"
        SHORTDESCRIPTION="Whether to release the database connection when finished processing">

    <JSB_PROPERTY NAME="size" DISPLAYNAME="box size" PROPTYPE="JS-expr" TYPE="number" ENV="server"
        VALUESET="1:256"
        SHORTDESCRIPTION="Size of box: 1 = drop box, more = list box">

    <JSB_PROPERTY NAME="maxRows" DISPLAYNAME="maxRows" PROPTYPE="JS-expr" TYPE="number" ENV="server"
        VALUESET="1:32767"
        SHORTDESCRIPTION="Maximum number of rows to fetch">

    // client properties
    <JSB_PROPERTY NAME="value" DISPLAYNAME="value" PROPTYPE="JS" TYPE="string" ENV="client"
        READMETHOD="getValue" WRITEMETHOD="setValue"
        ISRUNTIME ISBOUND ISDEFAULT SHORTDESCRIPTION="Current value of text">

    <JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS" ISDEFAULT>
    <JSB_EVENT NAME="onBlur" LISTENERMETHODS="onBlur" LISTENERTYPE="onBlurListener" EVENTMODEL="HTML">
    <JSB_EVENT NAME="onFocus" LISTENERMETHODS="onFocus" LISTENERTYPE="onFocusListener" EVENTMODEL="HTML">

    <JSB_METHOD NAME="getValue" TYPE="string" ENV="client"></JSB_METHOD>
    <JSB_METHOD NAME="setValue" TYPE="void" ENV="client">
        <JSB_PARAMETER NAME="newValue" TYPE="string">
    </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function writeln(str) {
  write(str + "\n")
}
writeln("<SCRIPT SRC=\"cSelectBox.js\"></SCRIPT>")


function addWhereCondition( sql, sCondition ) {
    sql = sql.toUpperCase()
    var sInsert
    i = sql.indexOf( "WHERE" )
    if ( i != -1  ) {
        // where clause exists
        sInsert = sCondition + " AND";
        i = i + 6;
    } else {
        // no where... need to add it also
        sInsert = "WHERE " + sCondition;
        i = sql.indexOf( "GROUP BY" );
        if ( i == -1 ) {
            i = sql.indexOf( "HAVING" );
            if ( i == -1 ) {
                i = sql.indexOf( "ORDER BY" );
            }
        }
        if ( i == -1 ) {
            // it goes at end
            return sql + " " + sInsert;
        }
    }
    return sql.substring( 0, i ) + sInsert + " " + sql.substring( i, sql.length );
}


function addOrdering( sql, sOrdering ) {
    sql = sql.toUpperCase()
    var sInsert
    i = sql.indexOf( "ORDER BY" )
    if ( i != -1  ) {
        // order by clause exists
        sInsert = sOrdering + ",";
        i = i + 9;
    } else {
        // need to add order by.  Isert at end.
        sInsert = "ORDER BY " + sOrdering;
        return sql + " " + sInsert;
    }
    return sql.substring( 0, i ) + sInsert + " " + sql.substring( i, sql.length )
}

function netscape_peas_DBSelect(params) {

    sSQL = "select * from " + params.table;

    if ( (params.filterCol != null) && (params.filterCol != "") ) {
        sWhereCondition = params.filterCol + " = \"" + unescape(request[params.filterCol]) + "\"";
        sSQL = addWhereCondition( sSQL, sWhereCondition );
    }

    if ( (params.sortCol != null) && (params.sortCol != "") ) {
        sOrdering =  params.sortCol;
        if ( false == params.sortAscending ) {
            sOrdering += " DESC";
        }
        sSQL = addOrdering( sSQL, sOrdering );
    }

    if (server.httpdlwVersion.indexOf("3.0") != -1) {  //--- Server 3.0 ---
        if (params.dbpool == null) {
            debug("Cursor's DBPool property is null - using generic database object.")
            cursorObj = database.cursor(sSQL, false)
        } else {
            pool = project[params.dbpool]
            if (request.connection == null) {
                request.connection = pool.connection(pool.id, pool.timeout)
            }
            cursorObj = request.connection.cursor(sSQL, false)
        }
    } else {  //---Server 2.0---
        cursorObj = database.cursor(sSQL, params.updatable)
    }

        // Prop assignments common to both server versions
    //cursorObj.cursorName = params.id
    cursorObj.maxRows = params.maxRows;



    // now generate the client object
    if ( ""==params.valueColumn ) {
        params.valueColumn = null;
    }
    if ( ""==params.textColumn ) {
        params.textColumn = null;
    }
    if ( ""==params.textExpr ) {
        params.textExpr = null;
    }
    writeln( "<SCRIPT>" );
    writeln( "params = new Object();" );
    writeln( "params.id = \"" + params.id + "\";" );
    writeln( "params.boxSize = " + params.size );
    if ( null!=params.defaultValue && "" != params.defaultValue ) {
        writeln( "params.defaultValue = \"" + params.defaultValue + "\";" );
    }
    if ( null!=params.multiple && "" != params.multiple ) {
        writeln( "params.multiple = \"" + params.multiple + "\";" );
    }
    if ( null != params.textColumn || null != params.textExpr ) {
        writeln( "params.optText = new Array();" );
    }
    if ( null != params.valueColumn ) {
        writeln( "params.optVal = new Array();" );
    }

    nRow = 0;
    while ( nRow < cursorObj.maxRows && cursorObj.next() ) {
        if ( null != params.valueColumn ) {
            writeln( "params.optVal[" + nRow + "] = \"" + cursorObj[params.valueColumn] +"\";" );
        }
        sTextResult = "?";
        if ( null != params.textExpr ) {
            with (cursorObj) {
                sTextResult = eval( params.textExpr );
            }
        } else if ( null != params.textColumn ) {
            sTextResult = cursorObj[params.textColumn];
        }
        write( "params.optText[" + nRow + "] = \"" + sTextResult +"\";" );
        nRow++;
    }
    writeln( params.id + " = new netscape_peas_select_client( params );" );
    writeln( "</SCRIPT>" );

        cursorObj.close()
    if ( (params.release) && (server.httpdlwVersion.indexOf("1.0") == -1) ) {
                request.connection.release()
    }

} // netscape_peas_DBSelect




    </JSB_CONSTRUCTOR>

</JSB>

<JSB_LISTENER NAME="onChangeListener">
    <JSB_METHOD NAME="onChange" TYPE="void">
        <JSB_PARAMETER NAME="propertyName" TYPE="string">
        <JSB_PARAMETER NAME="oldValue" TYPE="undefined">
        <JSB_PARAMETER NAME="newValue" TYPE="undefined">
    </JSB_METHOD>
</JSB_LISTENER>

