<JSB>
/*
 * DateDisplay.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.DateDisplay" DISPLAYNAME="Date Display" ENV="client">

    <JSB_PROPERTY NAME="type" DISPLAYNAME="Type" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="current,lastModified"
        SHORTDESCRIPTION="Display current or last-modified date">
    <JSB_PROPERTY NAME="showYear" DISPLAYNAME="Show Year?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Year?">
    <JSB_PROPERTY NAME="showMonth" DISPLAYNAME="Show Month?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Month?">
    <JSB_PROPERTY NAME="showMonthDay" DISPLAYNAME="Show Day of Month?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Day of Month?">
    <JSB_PROPERTY NAME="showWeekDay" DISPLAYNAME="Show Week Day?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Day of Week?">
    <JSB_PROPERTY NAME="showTime" DISPLAYNAME="Show Time?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Time of Day?">
    <JSB_PROPERTY NAME="showSeconds" DISPLAYNAME="Show Seconds?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display Seconds? (only if Display Time)">

<JSB_CONSTRUCTOR>
function addZeroIfNeeded(n) {
  if (n < 10)
    return "0" + n
  else
    return n
}

function netscape_peas_DateDisplay(params) {
  str = ""

  with (params) {
    if (type == "current")
       d = new Date()
    else
       d = new Date(document.lastModified)

    if (showTime) {
      str += d.getHours() + ":" + addZeroIfNeeded(d.getMinutes())
      if (showSeconds)  str += ":" + addZeroIfNeeded(d.getSeconds())
      str += " - "
    }
    if (showWeekDay) str += " " + d.toString().substring(0,3)
    if (showMonthDay) str += " " + d.getDate()
    if (showMonth) str += " " + d.toString().substring(4,7)
    if (showYear) str += " 19" + d.getYear() + " "
  }
  document.write( str )
} // netscape_peas_DateDisplay

</JSB_CONSTRUCTOR>
</JSB>

