/*
 * RowProvider.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;


import java.beans.PropertyChangeListener;

// cursor info needed by clients of both CursorDataProvider, and CursorDataReceiver
public interface RowProvider {

	/**
	 * Return the number of columns.  This is the "getter" method
	 * for the "numColumns" property.
	 */
	public int getNumColumns();

    /**
     * Return an array of column names.
     */
    public String[] getColumnNames();

    /**
     * Given a column's index (0..NumColumns), return its name
     */
    public String getColumnName( int iColumnNumber );

    /**
     * Return an array of column widths
     */
    public int[] getColumnWidths();

    /**
     * Given a column name, get its value.  This is a
     * "Dynamic-getter" method.  Unlike "normal" setter
     * methods ("void getFoo();"), dynamic-getters can be used
     * for properties whose names are known at compile time.
     */
	public Object getValueByName( String sColumnName );

    /**
     * Another flavor of "Dynamic-getter" method.
     * See @getValueByName.
     */
	public Object getValueByNumber( int iColumnNumber );

    /**
     * Row data providers implement addPropertyChangeListener and publish
     * it in the beaninfo as their OnPropertyChange "add listner" method.
     *
     * Technically, it does not need to be a member of this interface, but
     * hey, why not?
     */
    public void addPropertyChangeListener( PropertyChangeListener x );

    public void removePropertyChangeListener( PropertyChangeListener x );

    public void firePropertyChange( String propertyName, Object oldValue, Object newValue );


    public void addRowChangeListener( RowChangeListener oRowReceiver );

    public void removeRowChangeListener( RowChangeListener oRowReceiver );

    public void fireRowChange( int iChangeType, String sColumnAffected, Object oOldValue, Object oNewValue, RowProvider oRowProvider, NotifyList oNotify );




    public Object[] getColumnValues();
}
