/*
 * RowReceiver.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;



//import java.beans.PropertyChangeEvent;


/**
 * The RowReceiver receiver interface is implemented
 * by objects which support the receiving of a "record" of data
 * data is received through individual calls to oNCurrentRowsColumnChanged.
 *
 * One of the two objects is considered the "server" in the relationship.
 * The "server" is responsible for defining column names, which is done
 * with a call to initializeColumnNames on or after the registration of
 * this interface as the listner interface for the "server"'s property
 * change event.
 *
 */
public interface RowReceiver extends RowChangeListener {




    /**
     * Given a column's name, set its value to be this new value.
     * This is a "dymanic-setter". See @RowReceiver.getValueByName
     */
    public void setValueByName( String sColumnName, Object oNewValue );
    public void setValueByName( String sColumnName, Object oNewValue, NotifyList oNotify );

    /**
     * Different flavor "dynamic-setter".  See @setValueByName.
     */
    public void setValueByNumber( int iColumnNumber, Object oNewValue, NotifyList oNotify );

    /**
     * This method can be called by the data provider to
     * inform us (the client) of its column names
     */
    public boolean initializeColumnInfo( RowProvider oRowProvider );

}
