<JSB>
/*
 * SendMail.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.Sendmail" DISPLAYNAME="SendMail"
        ISHIDDEN ENV="server"
        SHORTDESCRIPTION="Server SendMail Object">

    <JSB_PROPERTY NAME="toAddress" DISPLAYNAME="To Address" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail address of sender">

    <JSB_PROPERTY NAME="fromAddress" DISPLAYNAME="From Address" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail addresses of recipients (comma separated)">

    <JSB_PROPERTY NAME="cc" DISPLAYNAME="Copies To" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail addresses to which to send copies (comma separated)">

    <JSB_PROPERTY NAME="subject" DISPLAYNAME="Subject" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Subject of mail message">

    <JSB_PROPERTY NAME="body" DISPLAYNAME="Message Body" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Body of message">

    <JSB_PROPERTY NAME="bcc" DISPLAYNAME="Blind Copies To" PROPTYPE="JS-expr" TYPE="Int"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail addresses to which to send blind copies (comma separated)">

    <JSB_PROPERTY NAME="organization" DISPLAYNAME="Organization" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Organization name for message header">

    <JSB_PROPERTY NAME="replyTo" DISPLAYNAME="Reply To" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail address to reply to (if not sender)">

    <JSB_PROPERTY NAME="smtpServer" DISPLAYNAME="SMTP Server" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of SMTP server (not required)">

    <JSB_PROPERTY NAME="errorsTo" DISPLAYNAME="Errors To" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="E-mail address to which send errors">

    <JSB_PROPERTY NAME="sendNow" DISPLAYNAME="Send Now?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Send the message when component is instantiated?">

    <JSB_PROPERTY NAME="successMsg" DISPLAYNAME="Success Message" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="String to display when message sent successfully.">

    <JSB_METHOD NAME="send" TYPE="void"> </JSB_METHOD>

    <JSB_METHOD NAME="errorMessage" TYPE="void"></JSB_METHOD>

    <JSB_METHOD NAME="errorCode" TYPE="boolean"></JSB_METHOD>

    <JSB_CONSTRUCTOR>
    function netscape_peas_SendMail(params) {
        mailObj = new SendMail()
        mailObj.To = params.toAddress
        mailObj.From = params.fromAddress
        mailObj.Cc = params.cc
        mailObj.Subject = params.subject
        mailObj.Body = params.body
        mailObj.Bcc = params.bcc
        mailObj.Organization = params.organization
        mailObj.ReplyTo = params.replyTo
        mailObj.Smtpserver = params.smtpServer
        mailObj.ErrorsTo = params.errorsTo
        mailObj.id = params.id
        if (params.sendNow) {
           if (!mailObj.send()) 
              write("Error " + mailObj.errorCode() + ": " + mailObj.errorMessage() )
           else
              write(params.successMsg)
        }

        return mailObj
    }
    </JSB_CONSTRUCTOR>
</JSB>
