<JSB>
/*
 * SimpleTable.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.SimpleTable" DISPLAYNAME="Simple Table"
        ISHIDDEN ENV="server"
        SHORTDESCRIPTION="Simple Database Table Display (server-side)">

    <JSB_PROPERTY NAME="dbpool" DISPLAYNAME="DBPool" PROPTYPE="JS" TYPE="string"
        SHORTDESCRIPTION="Name of DBPool to use (ES3)">

    <JSB_PROPERTY NAME="detailColumn" DISPLAYNAME="Detail Column" PROPTYPE="JS-expr" TYPE="string"
        SHORTDESCRIPTION="Name of column linked to by master query (if any)">

    <JSB_PROPERTY NAME="SQL" DISPLAYNAME="SQL Query" PROPTYPE="JS-expr" TYPE="SQLQuery"
        SHORTDESCRIPTION="SQL query to display">

    <JSB_PROPERTY NAME="release" DISPLAYNAME="Release Connection" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD="" DEFAULT_VALUE="true"
        SHORTDESCRIPTION="Whether to release the database connection when finished processing">

    <JSB_CONSTRUCTOR>
    function netscape_peas_SimpleTable(params) {
       if (params.detailColumn == null || params.detailColumn == "")
          whereClause = ""
       else
          whereClause = " where " + params.detailColumn + "=" + request[params.detailColumn]

       if (server.httpdlwVersion.indexOf("1.0") != -1) {   // Server 2.0 (LiveWire version 1.0)
          return database.SQLTable(params.SQL + whereClause)

       } else {                                            // Server 3.0
          if (params.dbpool == null) {
             debug("SimpleTable's dbpool property is null - using generic database object.")
             return database.SQLTable(params.SQL + whereClause)
	      } else {
             pool = project[params.dbpool]
             if (request.connection == null)
	            request.connection = pool.connection(pool.id, pool.timeout)
    	     t = request.connection.SQLTable(params.SQL + whereClause)
             if ( (params.release) && (server.httpdlwVersion.indexOf("1.0") == -1) )
    	        request.connection.release()
    	     return t
          }
       }
       return null
	}
    </JSB_CONSTRUCTOR>
</JSB>
