/*
 * TableApplet.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */



package netscape.peas;


import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import netscape.application.FoundationApplet;
import netscape.application.Application;
//import netscape.util.*;

public class TableApplet extends FoundationApplet implements Row, Table {

    /** This method must be implemented by the applet developer because
      * there is no way in the standard Java API for system classes (such as,
      * netscape.application) to look up an applet's class by name. The
      * static method <b>Class.forName()</b> simply looks up one level in the
      * stack and gets the ClassLoader associated with the method block of the
      * caller.
      * <p>
      * When the netscape.application classes are installed as
      * system classes, the ClassLoader is <b>null</b>. Thus, when code in
      * netscape.application calls <b>Class.forName()</b> it can only find
      * other system classes.
      * <p>
      * The solution is an API that allows code to
      * find the ClassLoader for an applet by URL, and a public API on
      * ClassLoader to ask it to load classes by name. Until those
      * enhancements can be made and distributed to all the world's Java
      * systems, applets must subclass FoundationApplet and
      * implement the following one-line method:
      * <pre>
      *     public abstract Class classForName(String className)
      *         throws ClassNotFoundException {
      *         return Class.forName(className);
      *     }
      * </pre>
      */
    public Class classForName(String className)
        throws ClassNotFoundException {
        return Class.forName(className);
    }

    public final static String gsApplicationClass       = "ApplicationClass";
    public final static String gsApplicationClassValue  = "netscape.peas.TableApplication";



    /**
     * This override averts the requirement for a <PARAM NAME="ApplicationClass" VALUE="netscape.peas.TableApplication"> tag in the the applet tag!
     */
    public String getParameter( String sName ) {
        if ( gsApplicationClass.equals( sName ) ) {
            return gsApplicationClassValue;
        } else {
            return super.getParameter( sName );
        }
    }


/*
    public Application pushIFCContext() {

        //System.out.println( "push IFC Conetxt" );
        return super.pushIFCContext();

    }


    public void popIFCContext() {
        //System.out.println( "pop IFC Conetxt" );
        super.popIFCContext();
    }
*/

    //====================================================================================



    // delegation is an ugly thing...
    // but no problem once we have established a bit of indirection...

    //-----------------------------------------------------------------------------------------------------------
    // GetInterface interface

    /**
     * Return an object which implements this specified (fully qualified) interface name.
     * If this interface is not implemented, return null.
     */
    public Object getInterface( String sInterfaceName ) {
        return ((TableApplication)application()).getInterface( sInterfaceName );
    }


    //-----------------------------------------------------------------------------------------------------------
    // TableInfo interface

    /**
     * Getter method for this cursor's "query" property.
     */
    public String getQuery() {
	    return ((TableApplication)application()).getQuery();
    }

	public void setQuery( String sNewQuery ) {
	    ((TableApplication)application()).setQuery( sNewQuery );
    }

	public int getFetchBufferSize() {
	    return ((TableApplication)application()).getFetchBufferSize();
    }

	public void setFetchBufferSize( int iNewBufferSize ) {
	    ((TableApplication)application()).setFetchBufferSize( iNewBufferSize );
    }

	public void executeQuery() {
	    ((TableApplication)application()).executeQuery();
    }

	public void deleteRow( int iRowNumber, boolean bNotify ) {
	    ((TableApplication)application()).deleteRow( iRowNumber, bNotify );
    }

	public void deleteRow() {
	    ((TableApplication)application()).deleteRow();
    }

	public void addRow() {
	    ((TableApplication)application()).addRow();
    }

    public void setTableValue( int iRow, int iColumn, Object oNewValue, NotifyList oNotify ) {
        ((TableApplication)application()).setTableValue( iRow, iColumn, oNewValue, oNotify );
    }

	public int getNumRowsFetched() {
	    return ((TableApplication)application()).getNumRowsFetched();
	}

	public boolean getRowsPending() {
	    return ((TableApplication)application()).getRowsPending();
	}

    public void fetchMoreRows() {
	    ((TableApplication)application()).fetchMoreRows();
    }

	public int getCurrentRowNumber() {
	    return ((TableApplication)application()).getCurrentRowNumber();
	}

	public boolean setCurrentRowNumber( int iNewRowNumber ) {
	    return ((TableApplication)application()).setCurrentRowNumber( iNewRowNumber );
	}

	public boolean doSetCurrentRowNumber( int iNewRowNumber, boolean bNotify, boolean bUpdateView, NotifyList oNotifyList ) {
	    return ((TableApplication)application()).doSetCurrentRowNumber( iNewRowNumber, bNotify, bUpdateView, oNotifyList );
    }

	public boolean nextRow() {
	    return ((TableApplication)application()).nextRow();
    }

	public boolean previousRow() {
	    return ((TableApplication)application()).previousRow();
    }

    // end of TableInfo interface
    //-----------------------------------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------------------------------
    // TableProvider interface

    public Table getTable() {
	    return ((TableApplication)application()).getTable();
    }

    public RowProvider getCurrentRowValues() {
	    return ((TableApplication)application()).getCurrentRowValues( );
    }

    public void addTableChangeListener( TableChangeListener oListener ) {
	    ((TableApplication)application()).addTableChangeListener( oListener );
    }

    public void removeTableChangeListener( TableChangeListener oListener ) {
	    ((TableApplication)application()).removeTableChangeListener( oListener );
    }

    public void fireTableChange( int iChangeType, int iRowAffected, int iColumnAffected, Object oNewValue, TableProvider oTableProvider, NotifyList oNotify ) {
        ((TableApplication)application()).fireTableChange( iChangeType, iRowAffected, iColumnAffected, oNewValue, oTableProvider, oNotify );
    }

    public Object[] getNonCurrentRowValues( int iRowNumber ) {
        return ((TableApplication)application()).getNonCurrentRowValues( iRowNumber );
    }

    public void updateCurrentRow() {
        ((TableApplication)application()).updateCurrentRow();
    }

    public void doUpdateRow( Object[] aColumnNames, Object[] aNewValues, Object[] aOldValues ) {
        ((TableApplication)application()).doUpdateRow( aColumnNames, aNewValues, aOldValues );
    }

    public boolean isCurrentRowChanged() {
        return ((TableApplication)application()).isCurrentRowChanged();
    }


    // end of TableProvider interface
    //-----------------------------------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------------------------------
    // TableReceiver interface

	public void tableChange( TableChangeEvent oEvent ) {
        ((TableApplication)application()).tableChange( oEvent );
	}

    // end of TableReceiver interface
    //-----------------------------------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------
    // Row interface

    public void setColumnNames( String[] aColumnNames, int[] aColumnWidths, NotifyList oNotify ) {
        ((TableApplication)application()).setColumnNames( aColumnNames, aColumnWidths, oNotify );
    }

    // end of Row interface
    //-----------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------------------------------
    // RowProvider interface

	public int getNumColumns() {
	    return ((TableApplication)application()).getNumColumns();
    }

    public String[] getColumnNames() {
	    return ((TableApplication)application()).getColumnNames();
    }

    public int[] getColumnWidths() {
        return ((TableApplication)application()).getColumnWidths();
    }

    public String getColumnName( int iColumnNumber ) {
	    return ((TableApplication)application()).getColumnName( iColumnNumber );
    }

    public Object[] getColumnValues() {
        return ((TableApplication)application()).getColumnValues();
    }

    public Object getValueByName( String sColumnName ) {
	    return ((TableApplication)application()).getValueByName( sColumnName );
    }

	public Object getValueByNumber( int iColumnNumber ) {
	    return ((TableApplication)application()).getValueByNumber( iColumnNumber );
    }

    public void addPropertyChangeListener( PropertyChangeListener x ) {
	    ((TableApplication)application()).addPropertyChangeListener( x );
    }

    public void removePropertyChangeListener( PropertyChangeListener x ) {
       ((TableApplication)application()).removePropertyChangeListener( x );
    }

    public void firePropertyChange(String propertyName,	Object oldValue, Object newValue) {
        ((TableApplication)application()).firePropertyChange( propertyName, oldValue, newValue );
    }

    public void addRowChangeListener( RowChangeListener oRowReceiver ) {
       ((TableApplication)application()).addRowChangeListener( oRowReceiver );

    }

    public void removeRowChangeListener( RowChangeListener oRowReceiver ) {
       ((TableApplication)application()).removeRowChangeListener( oRowReceiver );

    }
    public void fireRowChange( int iChangeType, String sColumnAffected, Object oOldValue, Object oNewValue, RowProvider oRowProvider, NotifyList oNotify ) {
        ((TableApplication)application()).fireRowChange( iChangeType, sColumnAffected, oOldValue, oNewValue, oRowProvider, oNotify );
    }

    // end of RowProvider interface
    //-----------------------------------------------------------------------------------------------------------


    //-----------------------------------------------------------------------------------------------------------
    // RowReceiver interface

	public void propertyChange( PropertyChangeEvent oEvent ) {
        ((TableApplication)application()).propertyChange( oEvent );
    }

     public void rowChange( RowChangeEvent oEvent ) {
        ((TableApplication)application()).rowChange( oEvent );
     }


    public void setValueByName( String sColumnName, Object oNewValue) {
        setValueByName( sColumnName, oNewValue, null );
    }
    public void setValueByName( String sColumnName, Object oNewValue, NotifyList oNotify ) {
       ((TableApplication)application()).setValueByName( sColumnName, oNewValue, oNotify );
    }

    public void setValueByNumber( int iColumnNumber, Object oNewValue, NotifyList oNotify ) {
       ((TableApplication)application()).setValueByNumber( iColumnNumber, oNewValue, oNotify );
    }

    public boolean initializeColumnInfo( RowProvider oRowProvider ) {
        return ((TableApplication)application()).initializeColumnInfo( oRowProvider );
    }

    // end of RowReceiver interface
    //-----------------------------------------------------------------------------------------------------------


} // TableApplet
