/*
 * TableProvider.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;




/**
 * Methods which allow a client to receive data from this cursor.
 *
 * to do: add/removeCursorChangeListner methods, etc.
 */
public interface TableProvider extends RowProvider  {

    public Table getTable();

    /**
     */
    public RowProvider getCurrentRowValues();

    /**
     * Getter method for "NumRowsFetched" property.  This
     * is the total number of rows satisfying the query if
     * and only if the "rowsPending" property is true.
     */
	public int getNumRowsFetched();


    /**
     * Add oListener a listener of TableChange events
     */
    public void addTableChangeListener( TableChangeListener oListener );

    /**
     * remove oListener as a listener of TableChange events
     */
    public void removeTableChangeListener( TableChangeListener oListener );

    /**
     * helper to fire table chanbe events
     */
    public void fireTableChange( int iChangeType, int iRowAffected, int iColumnAffected, Object oNewValue, TableProvider oTableProvider, NotifyList oNotify );

    /**
     * Return (without changing the "current row"), the values of this tables row # iRowNumer
     */
    public Object[] getNonCurrentRowValues( int iRowNumber );
    
    
    /**
     * Update (to underlying database) this table's current row
     */
    public void updateCurrentRow();
    
    
    /**
     * Helper to perform actual database update.  This, or updateCurrentRow can be overridden
     * to actually sen data to the database.
     */
    public void doUpdateRow( Object[] aColumnNames, Object[] aNewValues, Object[] aOldValues );
 
    
    /**
     * Return true if current row has been changed
     */
    public boolean isCurrentRowChanged();

        

} // TableProvider
