<JSB>
/*
 * DynamicDialog.jsb    1.1 97/11/24
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * By:
 * 1.0: garys@netscape.com
 * 1.1: cdk_team
 */

   /**
    * See DynamicDialogTest for examples.
    *
    * Retrieve values using  this.dialog.document.forms[0].fileName.value.
    * 
    */
   <JSB_DESCRIPTOR
        NAME="netscape.samples.widgets.DynamicDialog"
        DISPLAYNAME="Dynamic HTML Dialog"
        HELP_URL="netscape/samples/widgets/DynamicDialogSample.html">

   <JSB_PROPERTY NAME="dialogContent"
        DISPLAYNAME="dialog Content (text/html)" TYPE="string"
        DEFAULT_VALUE="Enter some text or content here..."> 

   <JSB_PROPERTY NAME="dialogSRC"
        DISPLAYNAME="dialog SRC (URL)" TYPE="string"
        DEFAULT_VALUE="URL"> 

   <JSB_PROPERTY NAME="dialogTitle"
        DISPLAYNAME="dialog Title" TYPE="string"
        DEFAULT_VALUE="Dialog Box">

   <JSB_PROPERTY NAME="dialogLabel"
        DISPLAYNAME="dialog Label" TYPE="string"
        DEFAULT_VALUE="Dialog Label"> 

   <JSB_PROPERTY NAME="dialogPageX" DISPLAYNAME="dialog pageX cord (pixels)" TYPE="number"
        DEFAULT_VALUE="window.innerWidth / 3"> 

   <JSB_PROPERTY NAME="dialogPageY" DISPLAYNAME="dialog pageY cord (pixels)" TYPE="number"
        DEFAULT_VALUE="window.innerHeight / 3"> 

   <JSB_PROPERTY NAME="dialogWidth" DISPLAYNAME="dialog Width (pixels)" TYPE="number"
        DEFAULT_VALUE="null"> 

   <JSB_PROPERTY NAME="dialogHeight" DISPLAYNAME="dialog Height (pixels)" TYPE="number"
        DEFAULT_VALUE="null"> 

   <JSB_PROPERTY NAME="dialogbgColor" DISPLAYNAME="dialog bgColor" TYPE="string"
        DEFAULT_VALUE="#CCCCCC"> 

   <JSB_PROPERTY NAME="dialogButton1Label" DISPLAYNAME="label for dialog Button1" TYPE="String"
        DEFAULT_VALUE="OK">

   <JSB_PROPERTY NAME="dialogButton2Label" DISPLAYNAME="label for dialog Button2" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton3Label" DISPLAYNAME="label for dialog Button3" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton4Label" DISPLAYNAME="label for dialog Button4" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton5Label" DISPLAYNAME="label for dialog Button5" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton1PageX" DISPLAYNAME="PageX for dialog Button1" TYPE="String"
        DEFAULT_VALUE="center">

   <JSB_PROPERTY NAME="dialogButton2PageX" DISPLAYNAME="PageX for dialog Button2" TYPE="String"
        DEFAULT_VALUE=""> 

   <JSB_PROPERTY NAME="dialogButton3PageX" DISPLAYNAME="PageX for dialog Button3" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton4PageX" DISPLAYNAME="PageX for dialog Button4" TYPE="String"
        DEFAULT_VALUE=""> 

   <JSB_PROPERTY NAME="dialogButton5PageX" DISPLAYNAME="PageX for dialog Button5" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton1Action" DISPLAYNAME="Event Handler for dialog Button1" TYPE="String"
        DEFAULT_VALUE="alert('replace this alert with your own function...');">

   <JSB_PROPERTY NAME="dialogButton2Action" DISPLAYNAME="Event Handler for dialog Button2" TYPE="String"
        DEFAULT_VALUE=""> 

   <JSB_PROPERTY NAME="dialogButton3Action" DISPLAYNAME="Event Handler for dialog Button3" TYPE="String"
        DEFAULT_VALUE="">

   <JSB_PROPERTY NAME="dialogButton4Action" DISPLAYNAME="Event Handler for dialog Button4" TYPE="String"
        DEFAULT_VALUE=""> 

   <JSB_PROPERTY NAME="dialogButton5Action" DISPLAYNAME="Event Handler for dialog Button5" TYPE="String"
        DEFAULT_VALUE="">


   <JSB_METHOD NAME="openDialog" TYPE="void"> </JSB_METHOD>
   <JSB_METHOD NAME="exampleDialog" TYPE="void"> </JSB_METHOD>

   <JSB_METHOD NAME="setDialogContent" TYPE="string"> </JSB_METHOD>
   <JSB_METHOD NAME="setDialogLabel" TYPE="string"> </JSB_METHOD>

   <JSB_CONSTRUCTOR>
    /**
     * Constructs a Dialog object 
     */
    function netscape_samples_widgets_DynamicDialog(params) {
        //properties
        this.dialogLabel   = params.dialogLabel;
        this.dialogTitle   = params.dialogTitle;
        this.dialogContent = params.dialogContent;
        this.dialogSRC     = params.dialogSRC;
        this.dialogPageX   = params.dialogPageX;
        this.dialogPageY   = params.dialogPageY;
        this.dialogWidth   = params.dialogWidth;
        this.dialogHeight  = params.dialogHeight;
        this.dialogbgColor = params.dialogbgColor;

        //methods
        this.openDialog     = netscape_samples_widgets_DynamicDialog_openDialog;
        this.exampleDialog  = netscape_samples_widgets_DynamicDialog_exampleDialog;
        this.setDialogContent = netscape_samples_widgets_DynamicDialog_setDialogContent; 
        this.setDialogTitle = netscape_samples_widgets_DynamicDialog_setDialogTitle;
        this.setDialogLabel = netscape_samples_widgets_DynamicDialog_setDialogLabel;
        this.setDialogPageX = netscape_samples_widgets_DynamicDialog_setDialogPageX;
        this.setDialogPageY = netscape_samples_widgets_DynamicDialog_setDialogPageY;
        this.setDialogWidth = netscape_samples_widgets_DynamicDialog_setDialogWidth;
        this.setDialogHeight = netscape_samples_widgets_DynamicDialog_setDialogHeight;
        this.setDialogBGcolor = netscape_samples_widgets_DynamicDialog_setDialogBGcolor;

        //button props
        this.dialogButton1Label = params.dialogButton1Label;
        this.dialogButton2Label = params.dialogButton2Label;
        this.dialogButton3Label = params.dialogButton3Label;
        this.dialogButton4Label = params.dialogButton4Label;
        this.dialogButton5Label = params.dialogButton5Label;
        this.dialogButton1PageX = params.dialogButton1PageX;
        this.dialogButton2PageX = params.dialogButton2PageX;
        this.dialogButton3PageX = params.dialogButton3PageX;
        this.dialogButton4PageX = params.dialogButton4PageX;
        this.dialogButton5PageX = params.dialogButton5PageX;
        this.dialogButton1PageY = params.dialogButton1PageY;
        this.dialogButton2PageY = params.dialogButton2PageY;
        this.dialogButton3PageY = params.dialogButton3PageY;
        this.dialogButton4PageY = params.dialogButton4PageY;
        this.dialogButton5PageY = params.dialogButton5PageY;
        this.dialogButton1Action = params.dialogButton1Action;
        this.dialogButton2Action = params.dialogButton2Action;
        this.dialogButton3Action = params.dialogButton3Action;
        this.dialogButton4Action = params.dialogButton4Action;
        this.dialogButton5Action = params.dialogButton5Action;

        this.dialogButtons = new Object();
        this.dialogButtons.array = new Array();
        this.dialogButtons.centered = new Array();
        this.dialogButtons.centeredWidth = 0;

        //button methods
        this.dialogButton = netscape_samples_widgets_DynamicDialog_dialogButton;
        this.setDialogButton = netscape_samples_widgets_DynamicDialog_setDialogButton;
        this.setTitlebarButton = netscape_samples_widgets_DynamicDialog_setTitlebarButton;
        this.addDialogButton = netscape_samples_widgets_DynamicDialog_addDialogButton;
        this.dialogButtonFocus = netscape_samples_widgets_DynamicDialog_dialogButtonFocus;
        this.dialogButtonMouseOver = netscape_samples_widgets_DynamicDialog_dialogButtonMouseOver;
        this.dialogButtonMouseOut = netscape_samples_widgets_DynamicDialog_dialogButtonMouseOut;
        this.dialogTitleMouseOver = netscape_samples_widgets_DynamicDialog_dialogTitleMouseOver;
        this.dialogTitleMouseOut = netscape_samples_widgets_DynamicDialog_dialogTitleMouseOut;

        this.drag = netscape_samples_widgets_DynamicDialog_drag;
        this.startDrag = netscape_samples_widgets_DynamicDialog_startDrag;
        this.endDrag = netscape_samples_widgets_DynamicDialog_endDrag;
        this.setDrag = netscape_samples_widgets_DynamicDialog_setDrag;
        this.dObjects = netscape_samples_widgets_DynamicDialog_dObjects;
        this.dObjects();
        this.setButtons = netscape_samples_widgets_DynamicDialog_setButtons;
        this.setButtons();
    }

    function netscape_samples_widgets_DynamicDialog_openDialog() {
        if(window.dialogLabel == this.dialogLabel || window.dialogLabel != null) return;
        window.dialogLabel = this.dialogLabel;
        this.win = new Object();
        this.win.base = new Layer(100);
        this.win.base.bgColor = '#000000';
        this.win.base.moveTo(this.dialogPageX,this.dialogPageY);
        this.win.base.d = this;
        this.win.edge   = netscape_samples_widgets_DynamicDialog_makeLayer('edge', '&nbsp;', this.win.base, 0, 0, '#DDDDDD', -1, -1);
        this.win.shadow = netscape_samples_widgets_DynamicDialog_makeLayer('shadow', '&nbsp;', this.win.base, 0, 0, '#888888', 1, 1);
        this.win.lite   = netscape_samples_widgets_DynamicDialog_makeLayer('lite', '&nbsp;', this.win.base, 0, 0, '#FFFFFF', 1, 1);
        this.win.gray   = netscape_samples_widgets_DynamicDialog_makeLayer('gray', '&nbsp;', this.win.base, 0, 0, '#CCCCCC', 2, 2);
        this.win.title  = netscape_samples_widgets_DynamicDialog_makeLayer('title', '<BODY><NOBR><FONT COLOR="#FFFFFF"><B><SPAN ID=font14>&nbsp; '+ this.dialogTitle +'</SPAN></B></FONT></BODY>', this.win.base, 0, 0, '#000084', 4, 4);
        this.win.temp   = netscape_samples_widgets_DynamicDialog_makeLayer('temp', this.dialogContent, this.win.base, 0, 0, "", 4, 4, "hide");
        if(this.win.temp.clip.width < 100) this.win.temp.clip.width = 100;
        if(this.dialogWidth == null || this.dialogWidth == "") this.boxW = this.win.temp.clip.width;
        else this.boxW  = this.dialogWidth -10;
        this.win.doc    = netscape_samples_widgets_DynamicDialog_makeLayer('doc', this.dialogContent, this.win.base, this.boxW, 0, this.dialogbgColor, 4, 25);
        if(this.dialogHeight == null || this.dialogHeight == "") this.boxH = this.win.doc.clip.height;
        else this.boxH = this.dialogHeight;
        this.win.doc.clip.height = this.boxH;
        if(this.win.title.clip.width >  this.boxW)  this.boxW = this.win.title.clip.width;
        for(var i=0; i<this.dialogButtons.array.length; i++) {
            var b = this.dialogButtons.array[i];
            this.setDialogButton(b.id, b.label, b.x, b.y, b.dialogButtonAction);
        }
        var centeredBase = (this.boxW - this.dialogButtons.centeredWidth) /2;
        for(var i=0; i<this.dialogButtons.centered.length; i++) {
            if(this.dialogButtons.centered[i -1]) centeredBase += this.dialogButtons.centered[i -1].clip.width +1;
            this.dialogButtons.centered[i].left = centeredBase;
        }
        this.dialogButtons.centeredWidth = 0;
        this.dialogButtons.centered.length = 0;
        if(this.dialogButtons.array.length <= 0) this.boxH = this.win.title.clip.height + this.win.doc.clip.height +5;
        else this.boxH = this.win.title.clip.height + this.win.doc.clip.height + this.win.buttonBase +5;
        if(this.win.doc.clip.width > this.boxW) this.boxW = this.win.doc.clip.width +5;
        this.boxW += 10;
          this.setTitlebarButton('titleX', "<DIV ID=sysFont>&nbsp;</DIV>", this.boxW - 20, 10, "");
        this.win.doc.clip.width     = this.boxW -4;
        this.win.base.clip.width    = this.boxW +4;
        this.win.base.clip.height   = this.boxH +4;
        this.win.edge.clip.width    = this.boxW +4;
        this.win.edge.clip.height   = this.boxH +4;
        this.win.base.visibility = 'inherit';
        this.win.lite.clip.width    = this.boxW +1;
        this.win.lite.clip.height   = this.boxH +1;
        this.win.shadow.clip.width  = this.boxW +2;
        this.win.shadow.clip.height = this.boxH +2;
        this.win.gray.clip.width    = this.boxW;
        this.win.gray.clip.height   = this.boxH;
        this.win.title.clip.width   = this.boxW -4;
        this.win.title.clip.height  = 20;
        this.win.title.setDrag      = this.setDrag;
        this.win.title.dragLayer    = this.win.base;
        this.win.title.onMouseOver  = this.dialogTitleMouseOver;
        this.win.title.onMouseOut   = this.dialogTitleMouseOut;
        if(this.dialogSRC != "URL" && this.dialogSRC != "") this.win.doc.src = this.dialogSRC;
        window.captureEvents(Event.RESIZE);
        window.onresize=netscape_samples_widgets_DynamicDialog_resetDialog;
    }

    function netscape_samples_widgets_DynamicDialog_makeLayer(id, content, Parent, width, height, color, x, y, viso) {
        if(!content) content = "&nbsp;";
        var l = new Layer(width,Parent);
        l.document.ids.font14.fontSize = 14;
        l.document.ids.sysFont.fontFamily = "Arial, Espy, sans-serif";
        l.document.open("text/html");
        l.document.writeln(content);
        l.document.close();
        l.moveTo(x,y);
        if(color != "") l.bgColor = color;
        if(width > 0) l.clip.width = width;
        if(height > 0) l.clip.height = height;
        if(!viso) l.visibility = "inherit";
        return l;
    }

    function netscape_samples_widgets_DynamicDialog_setButtons() {
        if(this.dialogButton1Label != "") this.addDialogButton('Button1', this.dialogButton1Label, this.dialogButton1PageX, this.dialogButton1PageY, this.dialogButton1Action);
        if(this.dialogButton2Label != "") this.addDialogButton('Button2', this.dialogButton2Label, this.dialogButton2PageX, this.dialogButton2PageY, this.dialogButton2Action);
        if(this.dialogButton3Label != "") this.addDialogButton('Button3', this.dialogButton3Label, this.dialogButton3PageX, this.dialogButton3PageY, this.dialogButton3Action);
        if(this.dialogButton4Label != "") this.addDialogButton('Button4', this.dialogButton4Label, this.dialogButton4PageX, this.dialogButton4PageY, this.dialogButton4Action);
        if(this.dialogButton5Label != "") this.addDialogButton('Button5', this.dialogButton5Label, this.dialogButton5PageX, this.dialogButton5PageY, this.dialogButton5Action);
    } 

    function netscape_samples_widgets_DynamicDialog_addDialogButton(id, label, x, y, dialogButtonAction) {
        newDialogButton = new this.dialogButton(id, label, x, y, dialogButtonAction);
        this.dialogButtons.array[this.dialogButtons.array.length++] = newDialogButton;
    }

    function netscape_samples_widgets_DynamicDialog_dialogButton(id, label, x, y, dialogButtonAction) {
        this.id = id;
        this.label = label;
        this.x = x;
        this.y = y;
        this.dialogButtonAction = dialogButtonAction;
    }

    function netscape_samples_widgets_DynamicDialog_setDialogButton(id, label, x, y, dialogButtonAction) {
        if(typeof(x) != 'number') { var trueX = x; x = 0; }
        if(typeof(y) != 'number') { y = 0; }
        label = '&nbsp;'+ label +'&nbsp;';
        this.win.button = netscape_samples_widgets_DynamicDialog_makeLayer(id, label, this.win.base, 0, 0, '#000000', x, y);

        this.boxH = this.win.title.clip.height + this.win.doc.clip.height + this.win.button.clip.height +10;
        this.win.button.clip.width += 4;
        this.win.button.clip.height += 4;

        this.win.buttonLite  = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -1, this.win.button.clip.height -1, '#FFFFFF', 0,0);
        this.win.buttonDark  = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -2, this.win.button.clip.height -2, '#666666', 1,1);
        this.win.buttonShade = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -3, this.win.button.clip.height -3, '#CCCCCC', 1,1);

        this.win.buttonContent = netscape_samples_widgets_DynamicDialog_makeLayer(id, label, this.win.button, this.win.button.clip.width -4, this.win.button.clip.height -4, '#BBBBBB', 2,2);
        this.win.buttonContent.win = this.win;
        this.win.buttonContent.label = label;
        this.win.buttonContent.dialogButtonAction = dialogButtonAction;
        this.win.buttonContent.onFocus = this.dialogButtonFocus;
        this.win.buttonContent.onMouseOver =  this.dialogButtonMouseOver;
        this.win.buttonContent.onMouseOut  =  this.dialogButtonMouseOut;
        this.win.button.top = this.win.title.clip.height + this.win.doc.clip.height +5;
        if(trueX == 'center') {
             this.dialogButtons.centered[this.dialogButtons.centered.length++] = this.win.button;
             this.dialogButtons.centeredWidth += this.win.button.clip.width;
        }
        if(trueX == 'right')  this.win.button.left = this.boxW - (this.win.button.clip.width +5);
        this.win.button.top += 7;
        this.win.buttonBase = this.win.button.clip.height +12;
    }

    function netscape_samples_widgets_DynamicDialog_setTitlebarButton(id, label, x, y, dialogButtonAction) {
        if(typeof(x) != 'number') { var trueX = x; x = 0; }
        if(typeof(y) != 'number') { y = 0; }
        this.win.button = netscape_samples_widgets_DynamicDialog_makeLayer(id, label, this.win.base, 0, 0, '#000000', x, y);
        this.win.button.clip.width = 18;
        this.win.button.clip.height = 16;        
        this.win.buttonLite  = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -1, this.win.button.clip.height -1, '#FFFFFF', 0,0);
        this.win.buttonDark  = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -2, this.win.button.clip.height -2, '#666666', 1,1);
        this.win.buttonShade = netscape_samples_widgets_DynamicDialog_makeLayer(id, "", this.win.button, this.win.button.clip.width -3, this.win.button.clip.height -3, '#CCCCCC', 1,1);
        this.win.buttonContent = netscape_samples_widgets_DynamicDialog_makeLayer(id, label, this.win.button, this.win.button.clip.width -4, this.win.button.clip.height -4, '#BBBBBB', 2,2);
        this.win.buttonContent.win = this.win;
        this.win.buttonContent.label = label;
        this.win.buttonContent.dialogButtonAction = dialogButtonAction;
        this.win.buttonContent.onFocus = this.dialogButtonFocus;
        this.win.buttonContent.onMouseOver =  this.dialogButtonMouseOver;
        this.win.buttonContent.onMouseOut  =  this.dialogButtonMouseOut;
        this.win.buttonContent.top -= 5;
        this.win.buttonContent.clip.top += 5;        
        this.win.buttonContent.clip.height += 5;        
        this.win.buttonContent.left += 3;        
        this.win.buttonContent.clip.left -= 3;        
        this.win.buttonContent.clip.width -= 3;        
        this.win.button.top = 6;
    }

    function netscape_samples_widgets_DynamicDialog_dialogButtonFocus() {
        this.bgColor='#888888';
        this.dialog = this.win.doc;
        eval( this.dialogButtonAction);
        this.win.base.visibility = 'hide';
        this.win = null;
        window.dialogLabel = null;
    }

    function netscape_samples_widgets_DynamicDialog_dialogButtonMouseOver() {
        this.bgColor='#AAAAAA';
    }

    function netscape_samples_widgets_DynamicDialog_dialogButtonMouseOut() {
        this.bgColor='#BBBBBB';
    }

    function netscape_samples_widgets_DynamicDialog_dialogTitleMouseOver() {
        this.setDrag(this);
        this.bgColor='#0000CD';
    }

    function netscape_samples_widgets_DynamicDialog_dialogTitleMouseOut() {
        this.bgColor='#000084';
    }

    function netscape_samples_widgets_DynamicDialog_setDialogContent(str) { 
        this.dialogContent = str; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogTitle(str) { 
        this.dialogTitle = str; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogLabel(str) { 
        this.dialogLabel = str; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogPageX(i) {
        this.dialogPageX = i; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogPageY(i) {
        this.dialogPageY = i; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogWidth(i) {
        this.dialogWidth = i; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogHeight(i) {
        this.dialogHeight = i; 
    }

    function netscape_samples_widgets_DynamicDialog_setDialogBGcolor(str) {
        this.dialogbgColor = str; 
    }

    function netscape_samples_widgets_DynamicDialog_setDrag(l) {
        d = this;
        d.dragLayer = l.dragLayer;
        d.captureEvents(Event.MOUSEUP|Event.MOUSEDOWN|Event.MOUSEDRAG);
        d.onmousedown=netscape_samples_widgets_DynamicDialog_startDrag;
        d.onmouseup=netscape_samples_widgets_DynamicDialog_endDrag;
    }

    function netscape_samples_widgets_DynamicDialog_drag(e) {
        //java.lang.System.out.println(e.pageX +" - "+ window.innerWidth);
        if(e.pageX > -5 && e.pageY > -5 && e.pageX < window.innerWidth && e.pageY < window.innerHeight) 
            d.dragLayer.moveBy(e.pageX-d.offX,e.pageY-d.offY);
        d.offX = e.pageX;
        d.offY = e.pageY;
        d.dragged = true;
    }

    function netscape_samples_widgets_DynamicDialog_startDrag(e) {
        d.dragLayer.captureEvents(Event.MOUSEMOVE);
        d.dragLayer.onmousemove=netscape_samples_widgets_DynamicDialog_drag; 
        d.offX=e.pageX;
        d.offY=e.pageY;
    }

    function netscape_samples_widgets_DynamicDialog_endDrag(e) {
        d.dragLayer.onmousemove=0;
        if(d.dragged == true) {
        d.dragLayer.visibility="hide"; 
        setTimeout('if(d.dragLayer) d.dragLayer.visibility="inherit";',1);
        d.dragLayer.releaseEvents(Event.MOUSEDOWN|Event.MOUSEUP|Event.MOUSEMOVE|Event.MOUSEDRAG);
        d.dragged = false;
        if(e.pageY < 0) d.dragLayer.top = -5;
        //if(e.pageX > window.width) d.dragLayer.top = window.width -20;
        }
    }

    function netscape_samples_widgets_DynamicDialog_dObjects() {
        if(!window.dialogObjects) {
            window.dialogObjects = new Array();
            window.dialogObjects[0] = this;
        } else {
            window.dialogObjects[window.dialogObjects.length++] = this;
        }
    }

    function netscape_samples_widgets_DynamicDialog_resetDialog(e) {
        // Resets dialog for reshowing..
        window.dialogLabel = null;

        for(var i=0; i < window.dialogObjects.length; i++) {
            if(window.dialogObjects[i].win)
                window.dialogObjects[i].openDialog();
        }
    }

    function netscape_samples_widgets_DynamicDialog_exampleDialog(str) {
        if(_param_)
            var dialog = new netscape_samples_widgets_DynamicDialog(_param_); //for JSB support
        else
            var dialog = new netscape_samples_widgets_DynamicDialog();

        var content = (str || '<CENTER><BR>Enter a local <B>filename</B>: <FORM><INPUT TYPE=FILE NAME="fileName" VALUE="" SIZE=40>&nbsp;&nbsp; </FORM></CENTER>');

        dialog.setDialogContent(content);
        dialog.setDialogTitle('Dialog [example]');
        dialog.setDialogLabel('example');
        dialog.setDialogBGcolor("#CCCCCC");

        //dialog.setDialogWidth(600);
        //dialog.setDialogHeight(150);
        //dialog.setDialogPageX(200);
        //dialog.setDialogPageY(250);
        //dialog.dialogSRC = "../../";

        dialog.addDialogButton("OKlabel",
                    "&nbsp;&nbsp;&nbsp;Show&nbsp;&nbsp;&nbsp;", "center", 3, "alert('You entered ' + this.dialog.document.forms[0].fileName.value)");
        dialog.addDialogButton("CancelLabel", "Cancel", "center", 3, "");

        //dialog.addDialogButton("AnotherLabel", "Another", "right", 3, "");
        dialog.openDialog();
    }

    </JSB_CONSTRUCTOR>
</JSB>
