/*
 * jsbdoc.java    1.0 97/11/06
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * -garys
 */
package netscape.samples.jsbdoc; 

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.Graphics;
import java.beans.*;
import java.io.Serializable;

import netscape.samples.jsbdoc.ReadFile;
import netscape.samples.jsbdoc.ParseJSB;
import netscape.samples.jsbdoc.WriteFile;

/**
 * Invisible Java "Bean" for JSBDoc...
 *
 * includes cmd-line option 
 * usage: java jsbdoc [filename.jsb]
 * <p>
 * Note: Currently does not support parsing
 * of secondary JS files referenced by optional
 * SRC attribute of JSB_CONSTRUCTOR tag.
 * <p>
 * @see main
 *
 * @version 1.0
 * @author garys@netscape.com
 */
public class jsbdoc implements Serializable {

    private String fileName;
    private String finalDoc;

    /**
     * Constructs a jsbdoc Bean with the a default fileName.
     */
    public jsbdoc() {
	    this("jsbdoc.jsb");
    }

    /**
     * Constructs a jsbdoc Bean with the specified fileName.
     * @param fileName the fileName of the JSB to be doc'd
     */
    public jsbdoc(String fileName) {
	    super();
	    this.fileName = fileName;
    }

    public String getFileName() {
        return fileName;
    }
    public void setFileName(String newFileName) {
        fileName = newFileName;
    }
    public String getFinalDoc() {
        return finalDoc;
    }
    public void setFinalDoc(String newFinalDoc) {
        finalDoc = newFinalDoc;
    }

    public void runParser(String JSBname, Vector fileLines) {
        try {
            ParseJSB p = new ParseJSB(JSBname);
            p.setFileLines(fileLines);
            p.setParsedDoc();
            setFinalDoc(p.getParsedDoc().toString());
            System.out.println("done parsing ");
        } catch (Exception e) {
            System.out.println("jsbdoc Exception:\n" + e);
        }
    }

    public void generateJSBDoc() {
        try {
            String JSBname = fileName.substring(0, fileName.lastIndexOf("."));
            System.out.println("Generating documention for JSB "+ JSBname);
            String docFileName = JSBname +"_jsb.html";
            ReadFile rf = new ReadFile(fileName);
            System.out.println("Generating "+ docFileName );
            ParseJSB p = new ParseJSB(JSBname);
            p.setFileLines(rf.getFileLines());
            p.setParsedDoc();
            WriteFile wr = new WriteFile(docFileName, p.getParsedDoc());
        } catch (Exception e) {
            System.out.println("jsbdoc Exception:\n" + e);
        }
    }

    /**
     * cmd-line option for jsbdoc
     */
    public static void cmdLine(String fileName) {
        try {
            String JSBname = fileName.substring(0, fileName.lastIndexOf("."));
            System.out.println("Generating documention for JSB "+ JSBname);
            String docFileName = JSBname +"_jsb.html";
            ReadFile rf = new ReadFile(fileName);
            System.out.println("Generating "+ docFileName );
            ParseJSB p = new ParseJSB(JSBname);
            p.setFileLines(rf.getFileLines());
            p.setParsedDoc();
            WriteFile wr = new WriteFile(docFileName, p.getParsedDoc());
        } catch (Exception e) {
            System.out.println("jsbdoc Exception:\n" + e);
        }
    }

    /**
     * for cmd-line option
     * usage: java jsbdoc [filename]
     */
    public static void main(String args[]) {
        try {
            String fileName = args[0];
            cmdLine(fileName);
        } catch (Exception e) {
            System.out.println("usage: java jsbdoc [filename]");
        }
    }


    //  Methods for registering listeners:
    public void addPropertyChangeListener(PropertyChangeListener l) {
	    changes.addPropertyChangeListener(l);
    }
    public void removePropertyChangeListener(PropertyChangeListener l) {
	    changes.removePropertyChangeListener(l);
    }

    //  Support for serialization
    private void readObject(java.io.ObjectInputStream s)
        		throws java.lang.ClassNotFoundException,
			       java.io.IOException {
		s.defaultReadObject();
    }

    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

}
