/*
 * CSCException.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;

import netscape.palomar.util.*;

public class CSCException extends CascadedException {

    public static final int TABLE_TAG  = 3301;
    public static final int HEADER_ROW = 3302;
    public static final int DATA_ROWS  = 3303;
//    public static final int RESULT_TABLE_TAG = 3304;
//    public static final int RESULT_TABLE_TAG = 3305;
//    public static final int RESULT_TABLE_TAG = 3306;
//    public static final int RESULT_TABLE_TAG = 3307;
//    public static final int RESULT_TABLE_TAG = 3308;
//    public static final int RESULT_TABLE_TAG = 3309;

    public CSCException(int id) {
         super(id);
    }
    public CSCException(int id, Exception e) {
        super(id,e);
    }

    protected String lookup(int id)
    {
        switch (id)
        {
        case TABLE_TAG: return "Missing TABLE tag in retrieved page $url";
        case HEADER_ROW: return "Table does not have a header row ($url)";
        case DATA_ROWS: return "Table does not have any data rows ($url)";
        default: return "identifer "+id+" not in lookup table!";
        }
    }
}
