<JSB>
/*
 * Concat.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

<JSB_DESCRIPTOR
    name="netscape.peas.Concat"
    displayName="Concat"
    shortDescription="Concatenate two string together with three static strings"
    ENV="client">

<JSB_PROPERTY NAME="result" DISPLAYNAME="Result" PROPTYPE="JS" TYPE="string"
    ISBOUND
    SHORTDESCRIPTION="The resulting concatenated value">

<JSB_PROPERTY NAME="in1" DISPLAYNAME="Input 1" PROPTYPE="JS" TYPE="string"
    WRITEMETHOD="setIn1"
    SHORTDESCRIPTION="Input string number 1">

<JSB_PROPERTY NAME="in2" DISPLAYNAME="Input 2" PROPTYPE="JS" TYPE="string"
    WRITEMETHOD="setIn2"
    SHORTDESCRIPTION="Input string number 2">

<JSB_PROPERTY NAME="stat1" DISPLAYNAME="Static 1" PROPTYPE="JS" TYPE="string"
    SHORTDESCRIPTION="String that will come at beginning of result">
<JSB_PROPERTY NAME="stat2" DISPLAYNAME="Static 2" PROPTYPE="JS" TYPE="string"
    SHORTDESCRIPTION="String that will come between two input values">
<JSB_PROPERTY NAME="stat3" DISPLAYNAME="Static 3" PROPTYPE="JS" TYPE="string"
    SHORTDESCRIPTION="String that will come at end of result">

<JSB_METHOD NAME="setIn1" TYPE="void">
    <JSB_PARAMETER name="newin" type="string">
</JSB_METHOD>
<JSB_METHOD NAME="setIn2" TYPE="void">
    <JSB_PARAMETER name="newin" type="string">
</JSB_METHOD>
<JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS">

<JSB_CONSTRUCTOR>
function netscape_peas_concat_setin1( s ) {
    this.in1 = s
    this.recalc()
}
function netscape_peas_concat_setin2( s ) {
    this.in2 = s
    this.recalc()
}

function netscape_peas_concat_recalc() {
    this.result = "" + this.stat1 + this.in1 + this.stat2 + this.in2 + this.stat3;
    this.onChange("result", "", this.result)
}

function netscape_peas_Concat(params) {
    this.stat1 = params.stat1
    this.stat2 = params.stat2
    this.stat3 = params.stat3
    this.in1   = params.in1
    this.in2   = params.in2
    this.setIn1 = netscape_peas_concat_setin1;
    this.setIn2 = netscape_peas_concat_setin2;
    this.recalc = netscape_peas_concat_recalc;
}
</JSB_CONSTRUCTOR>
</JSB>
