<JSB>
/*
 * DummyCursor.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.DummyCursor" DISPLAYNAME="Dummy Cursor"
        ISHIDDEN ENV="client"
        SHORTDESCRIPTION="Dummy client-side database cursor">

    <JSB_PROPERTY NAME="name" DISPLAYNAME="Name" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of object">

    <JSB_PROPERTY NAME="numRows" DISPLAYNAME="NumRows" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Number of Rows">

    <JSB_PROPERTY NAME="currentRowNumber" DISPLAYNAME="CurrentRow" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="setCurrentRowNumber"
        SHORTDESCRIPTION="Current Row Number">

    <JSB_PROPERTY NAME="updatable" DISPLAYNAME="Updatable" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Is Cursor Updatable">


    <JSB_METHOD NAME="nextRow" TYPE="boolean"> </JSB_METHOD>

    <JSB_METHOD NAME="previousRow" TYPE="boolean"> </JSB_METHOD>

    <JSB_METHOD NAME="setCurrentRowNumber" TYPE="void" ENV="client">
        <JSB_PARAMETER NAME="newRowNumber" TYPE="number">
    </JSB_METHOD>
    <JSB_METHOD NAME="getCurrentRowNumber" TYPE="number"> </JSB_METHOD>

    <JSB_METHOD NAME="getNumRowsFetched" TYPE="number" ENV="client"> </JSB_METHOD>

    <JSB_METHOD NAME="getInterface" TYPE="object">
      <JSB_PARAMETER NAME="className" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="executeQuery" TYPE="void" ENV="client"> </JSB_METHOD>


    <JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS">
    <JSB_EVENT NAME="netscape.peas.RowChange" LISTENERMETHODS="rowChange" LISTENERTYPE="netscape.peas.RowChangeListener" EVENTMODEL="AWT11">

    <JSB_INTERFACE NAME="netscape.peas.GetInterface">
    <JSB_INTERFACE NAME="netscape.peas.Row">
    <JSB_INTERFACE NAME="netscape.peas.RowChangeListener">

    <JSB_CONSTRUCTOR>

function _getInterface( sInterface ) {
    if ( sInterface == "netscape.peas.Row" || sInterface == "netscape.peas.RowChangeListener" ) {
        if ( null == this.oRowSupport ) {
        	oRowSupport = new Packages.netscape.peas.RowSupport(true);
            this.oRowSupport = oRowSupport;
        }
        return oRowSupport;
     } else {
        return null;
    }
}


function _next() {
    return this.setCurrentRowNumber(this.currentRow+1);
}

function _previous() {
    return this.setCurrentRowNumber(this.currentRow-1);
}// _previous


function _setCurrentRowNumber(iNewRowNumber) {
    if (iNewRowNumber<0||iNewRowNumber>=this.numRows) {
        alert("setRowNumber out of range!")
        return false
    } else {
        iOldRowNumber = this.currentRow;
        if ( iOldRowNumber != iNewRowNumber ) {
            this.currentRow = iNewRowNumber;
            for (prop in this) {
                if (prop.indexOf("records_") != -1) {
                    if (iOldRowNumber==-1) {
                       oldValue = null;
                    } else {
                       oldValue = Rows[iOldRowNumber][prop];

                        // if we allow "writes", get value from RowSupport's buffer
                        if (null!=this.oRowSupport) {
                            // update our table from what rowsupport holds
                            Rows[iOldRowNumber][prop] = this.oRowSupport.getValueByName( prop );
                        } else {
                            Rows[iOldRowNumber][prop] = this[prop]
                        }
                    }

                    this[prop] = Rows[iNewRowNumber][prop]
                    this.fireChangeEvent(prop, oldValue, Rows[iNewRowNumber][prop], true )

                    if (null!=this.oRowSupport) {
                        this.oRowSupport.setValueByName( prop, Rows[iNewRowNumber][prop], null );
                    }
                }
            } // for
            this.fireChangeEvent( "currentRowNumber", iOldRowNumber, iNewRowNumber, false);
        } // if
        return true
    } // else
} // _setRowNumber


function _setValueByName( sName, newValue ) {
    this[sName] = newValue;
    if (null!=this.oRowSupport) {
       this.oRowSupport.setValueByName( sName, newValue, null )
    }
}

function _getNumRowsFetched() {
    return this.numRows;
}

function _executeQuery() {

   if (null!=this.oRowSupport) {
      // tell our helper object about our data...
      this.oRowSupport.setNumColumns(7);
      this.oRowSupport.setColumnName(0,"records_custname");
      this.oRowSupport.setColumnName(1,"records_address");
      this.oRowSupport.setColumnName(2,"records_city");
      this.oRowSupport.setColumnName(3,"records_state");
      this.oRowSupport.setColumnName(4,"records_zip");
      this.oRowSupport.setColumnName(5,"records_phone");
      this.oRowSupport.setColumnName(6,"records_id");

       this.currentRow = -1
       // tell our listeners about our data
      this.oRowSupport.fireRowChange(1,null,null,null,oRowSupport,null);
   }
}


function _fireChangeEvent( prop, oldValue, newValue, bJSOnly ) {

   if (null!=this.oRowSupport&&(!bJSOnly)) {
       this.oRowSupport.firePropertyChange(prop,oldValue,newValue)
       this.oRowSupport.fireRowChange(2,prop,oldValue,newValue,oRowSupport,null)
   }

   if (null!=this.onChange) {
       this.onChange(prop,oldValue,newValue)
   }
}


function Row() {
   this.records_custname = arguments[0]
   this.records_id = arguments[1]
   this.records_address = arguments[2]
   this.records_city = arguments[3]
   this.records_state = arguments[4]
   this.records_zip = arguments[5]
   this.records_phone = arguments[6]
}

function netscape_peas_DummyCursor(params) {
   dc = new Object()
   for (p in params) {
        if (p.indexOf("records_") != -1) {
            dc[p] = params[p]
        }
   }

    dc.records_id = "";
    dc.records_custname = "";
    dc.records_address = "";
    dc.records_city = "";
    dc.records_state = "";
    dc.records_zip = "";
    dc.records_phone = "";

   dc.numRows = 10
   dc.nextRow = _next
   dc.previousRow = _previous
   dc.currentRow = -1
   dc.setCurrentRowNumber = _setCurrentRowNumber
   dc.fireChangeEvent = _fireChangeEvent
   dc.executeQuery = _executeQuery
   dc.getInterface = _getInterface
   dc.getNumRowsFetched = _getNumRowsFetched

   dc.setValueByName = _setValueByName


   Rows = new Array(10)
   Rows[0] = new Row("Ishikawa, Eli & Sally","100","1143 N 16th Street","Nashville","TN","33214","(503)555-6045")
   Rows[1] = new Row("Barnes, Allie","101","206 N 10th Street","Newport","OR","99999","(503)555-3195")
   Rows[2] = new Row("Tunison, Micheal J.","102","981 S Sycamore Avenue","Portland","OR","92349","(503)555-0116")
   Rows[3] = new Row("Maxwell, Steve & Tanya","103","435 N Westview Place","Santa Cruz","CA","93105","(503)555-3171")
   Rows[4] = new Row("Curtis, T Gray","104","1205 W 26th Street","Lincon City","OR","99999","(503)555-6517")
   Rows[5] = new Row("Breinholt, Sean & Vibeke","105","432 S 6th Street","Newport","OR","99999","(503)555-3818")
   Rows[6] = new Row("Richter, Bill & Joan","106","22554 Wells Creek Road","Toledo","OH","99999","(503)555-2814")
   Rows[7] = new Row("Corwin, Gerald","107","805 Cline Hill Loop","Newport","OR","99999","(503)555-4388")
   Rows[8] = new Row("Reid, Boots","108","247 S Twin Fir Circle","Dallas","TX","76114","(503)555-5123")
   Rows[9] = new Row("Luttrell, Jessica","109","1715 W 29th","Lincon City","OR","99999","(503)555-4926")
   return dc
}
    </JSB_CONSTRUCTOR>
</JSB>

<JSB_LISTENER NAME="onChangeListener">
    <JSB_METHOD NAME="onChange" TYPE="void">
        <JSB_PARAMETER NAME="propertyName" TYPE="string">
        <JSB_PARAMETER NAME="oldValue" TYPE="undefined">
        <JSB_PARAMETER NAME="newValue" TYPE="undefined">
    </JSB_METHOD>
</JSB_LISTENER>
