<JSB>
/*
 * Label.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
    <JSB_DESCRIPTOR NAME="netscape.peas.Label" DISPLAYNAME="Label"
        ISHIDDEN ENV="server"
        SHORTDESCRIPTION="Text Label (server-side)">

    <JSB_PROPERTY NAME="name" DISPLAYNAME="Name" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of object">

    <JSB_PROPERTY NAME="value" DISPLAYNAME="Value" PROPTYPE="JS-expr" TYPE="object" ISBOUND
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Text to display in label">

    <JSB_PROPERTY NAME="fontSize" DISPLAYNAME="Font Size" PROPTYPE="JS" TYPE="number" VALUESET="1:7"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Font Size">

    <JSB_PROPERTY NAME="fontColor" DISPLAYNAME="Font Color" PROPTYPE="JS" TYPE="color"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Font Color">

    <JSB_PROPERTY NAME="fontFace" DISPLAYNAME="Font" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="List of Fonts to use">


    <JSB_PROPERTY NAME="italic" DISPLAYNAME="Italic" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display in italic font?">

    <JSB_PROPERTY NAME="bold" DISPLAYNAME="Bold" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Display in bold font?">

    <JSB_PROPERTY NAME="underline" DISPLAYNAME="Underline" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Underline?">

<JSB_CONSTRUCTOR>
function netscape_peas_Label(params) {

   with (params) {
      retVal = ""; endStr = ""
      if (italic) {
          retVal += "<I>"
          endStr += "</I>"
      }
      if (bold) {
          retVal += "<B>"
          endStr += "</B>"
      }
      if (underline) {
          retVal += "<U>"
          endStr += "</U>"
      }
      retVal += "<FONT COLOR=" + fontColor + " FACE=" + fontFace + " SIZE=" + fontSize + ">"
      retVal += value + endStr + "</FONT>"
      write( retVal )
  }
} //netscape_peas_Label
</JSB_CONSTRUCTOR>
</JSB>
