/*
 * NotifyEvent.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;




/**
 * The Notify event is used to prevent cycles and undue proliferation of events.
 * We derive our events from this class, so that the NotifyList interface is implemented.
 * NOTE: When the JDK implements this we will use that implementation.
 */
public class NotifyEvent implements NotifyList {

    /**
     * default constructor
     */
    NotifyEvent() {
    }

    //----------------------------------------------------
    // NotifyList interface

    /**
     * Add the given object to this list.
     */
    public void addToVisitedList( Object o ) {
        if ( null == moNotifyList ) {
            moNotifyList = new NotifyListSupport();
        }
        moNotifyList.addToVisitedList( o );
    }

    /**
     * Return true if the given object is on this list.
     */
    public  boolean isOnVisitedList( Object o ) {
        if ( null == moNotifyList ) {
            return false;
        } else {
            return moNotifyList.isOnVisitedList( o );
        }
    }

    //--------------------------------------------------------
    // accessors

    public NotifyList getNotifyList() {
        return moNotifyList;
    }

    public void setNotifyList( NotifyList oNotify ) {
        moNotifyList = oNotify;
    }


    //----------------------------------------------------------------
    // member variables

    private NotifyList moNotifyList = null;


} // NotifyEvent
