/*
 * RowChangeEvent.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;




/**
 * A row change event is sent between objects supporting the
 * Row interface.
 */
public class RowChangeEvent extends NotifyEvent {

    /**
     * Construct a Row cange event give a slew of parameters.
     */
    public RowChangeEvent( int iType, String sColumnAffected, Object oOldValue, Object oNewValue, RowProvider oRowProvider ) {
        miType = iType;
        moRowProvider = oRowProvider;
        msColumnAffected = sColumnAffected;

        if ( null != sColumnAffected ) {
            msColumnAffected = new String( sColumnAffected );
        }
        if ( oOldValue instanceof String ) {
            moOldValue = new String( (String)oOldValue );
        }
        if ( oNewValue instanceof String ) {
            moNewValue = new String( (String)oNewValue );
        }
    }

    /**
     * Return the "type" attribute of this event.
     */
    public int getType() {
        return miType;
    }

    /**
     * Return the "columnAffected" attribute of this event.
     */
    public String getColumnAffected() {
        return msColumnAffected;
    }

    /**
     * Return interface to RowProvider (part of Row interface).  This
     * interface may be used to obtain column information (names, types, etc.)
     */
    public RowProvider getRowProvider() {
        return moRowProvider;
    }

    /**
     * Get the "oldValue" attribute for this RowChangEvent object.
     */
    public Object getOldValue() {
        return moOldValue;
    }

    /**
     * Get the "newValue" attribute for this RowChangEvent object.
     */
    public Object getNewValue() {
        return moNewValue;
    }

    //-------------------------------------------------------------------
    // member variables

    public static final int UNKNOWN_TYPE            = 0;
    public static final int COLUMN_INFO_CHANGED     = 1;
    public static final int VALUE_CHANGED           = 2;

    private int miType = 0;
    private RowProvider moRowProvider = null;
    private String msColumnAffected = null;
    private Object moOldValue = null;
    private Object moNewValue = null;

} // RowChangedEvent
