<JSB>
/*
 * SQLExec.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.SQLExec"
        DISPLAYNAME="SQL Statement Executor"
        SHORTDESCRIPTION="SQL Command Execution" ENV="server" ISHIDDEN>

    <JSB_PROPERTY NAME="database" DISPLAYNAME="Database" PROPTYPE="JS-expr" TYPE="object"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of LiveWire database object to operate on">

    <JSB_PROPERTY NAME="SQL" DISPLAYNAME="SQL Statement" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        VALUESET=""
        SHORTDESCRIPTION="SQL Statement to execute">

    <JSB_PROPERTY NAME="InsertOK" DISPLAYNAME="Insert OK?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Allow insert of new records into database?">

    <JSB_PROPERTY NAME="UpdateOK" DISPLAYNAME="Update OK?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Allow update of database records?">

    <JSB_PROPERTY NAME="DeleteOK" DISPLAYNAME="Delete OK?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Allow deleting of records from database?">

    <JSB_METHOD NAME="" TYPE="">
        <JSB_PARAMETER NAME="" TYPE="" >
    </JSB_METHOD>


    <JSB_CONSTRUCTOR>
function getES2Connection(s) {
    params = new Object()
    n = 0
    alert("LENGTH is " + s.length)
    while (s.length > 0) {
        params[n] = s.substring(s.lastIndexOf("\\")+1, s.length)
        s = s.substring(0, i)
        n++
        }
        database.connect(params[0], params[1], params[2], params[3], params[4])
}

function displayQuery(c) {
	write("<TABLE BORDER>")
	write("<TR>")
	for (col in c)
		write( "<TH>" + col + " </TH>" )
	write("</TR>")
	while (c.next()) {
		write("<TR>")
		for (col in c)
			write("<TD>" + c[col] + "</TD>")
		write("</TR>")
	}
	write("</TABLE>")
} //displayQuery

function SQLExec(params) {
    if ( ( (request.SQL == null) || (request.SQL == "") ) && ( (request.update == null) || (request.update == "") ) )
    	write("<P>Error - No query or update defined.")

	if (server.httpdlwVersion.indexOf("3.0") != -1) {
        db = params.database
	} else {
        getES2Connnection(client.currentConnection)
        db = database
    }

	if  (!db.connected()) {
		write("Error: Not connected to database.")
		write("<P>Major Error Message: " + database.majorErrorMessage() )
		write("<P>Minor Error Message: " + database.minorErrorMessage() )
		write("<P>Major Error Code: " + database.majorErrorCode() )
		write("<P>Minor Error Code: " + database.minorErrorCode() )
	}

	if ( (request.SQL != null) && (request.SQL != "") ) {
		curs = db.cursor(request.SQL)
		displayQuery(curs)

	} else if ( (request.update != null) && (request.update != "") ) {
		result = db.execute(request.update)
		if (result == 0)
			write("<P>Operation successful:<BR>" + request.update)
		else
			write("<P>Operation failed:<BR>" + request.update + "<BR>Status code: " + result)
	}
}


    </JSB_CONSTRUCTOR>
</JSB>
