<JSB> 
/*
 * ScrollingBanner.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.ScrollingBanner" DISPLAYNAME="Scrolling Banner"
        ENV="client"
        CLASS="" CUSTOMIZER=""
        SHORTDESCRIPTION="JavaScript Scrolling Banner">
    <JSB_PROPERTY NAME="msg" DISPLAYNAME="Message" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Text message to scroll in status bar">
    <JSB_PROPERTY NAME="speed" DISPLAYNAME="Scroll Speed" PROPTYPE="JS" TYPE="number" VALUESET="0:200"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Scrolling Speed">
    <JSB_PROPERTY NAME="position" DISPLAYNAME="Start Position" PROPTYPE="JS" TYPE=""
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Starting position of message">

    <JSB_METHOD NAME="scroll" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="stop" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="reset" TYPE="void"> </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function scroll() {
  if (this.currentPos == null) 
     this.currentPos = this.pos

  for (i = 0; i < this.currentPos; i++) 
     this.out += " "

  if (this.currentPos >= 0)
     this.out += this.msg
  else 
     this.out = this.msg.substring(-this.currentPos, this.msg.length)

  window.status = this.out
  this.out = " "
  this.currentPos--
  if (this.currentPos < -(this.msg.length)) 
     this.reset()

  execStr = this.id + ".scroll()"
  this.bannerID = setTimeout (execStr, 1000/this.speed)
}

 function stop() {
       clearTimeout(this.bannerID);
 }

function reset() {
  this.currentPos = this.pos
}

function netscape_peas_ScrollingBanner(params) {
  this.msg = params.msg
  this.speed = params.speed
  if (this.speed==0) this.speed = 0
  this.pos = params.position
  this.out = " "
  this.id = params.id
  this.scroll = scroll
  this.stop = stop
  this.reset = reset
}
    </JSB_CONSTRUCTOR>
</JSB>
