/*
 * TableChangeEvent.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;





/**
 * The TableChangeEvent, along with the TableChangeListener allow components to
 * be wired together and transfer entire database like tables of data to and from
 * one another.
 *
 * The TableChangeEvent sends notifications to listeners about changes affecting
 * the table itself (e.g. new row added, query re-executed, etc).
 *
 * Note that much of the acutal data transfer is accomplished using the RowChangeEvent
 * and the PropertyChangeEvent, which are also fired in any "Table" connection.
 */
public class TableChangeEvent extends NotifyEvent {

    /**
     * Construct a TableChange event, given type, row affected, and RowProvider
     */
    TableChangeEvent(
        int iChangeType,
        int iRowAffected,
        int iColumnAffected,
        Object oNewValue,
        TableProvider oTableProvider ) {
        super();

        miChangeType = iChangeType;
        miRowAffected = iRowAffected;
        miColumnAffected = iColumnAffected;
        moNewValue = oNewValue;
        moTableProvider = oTableProvider;
    }

    public int getChangeType() {
        return miChangeType;
    }

    public int getRowAffected() {
        return miRowAffected;
    }

    public int getColumnAffected() {
        return miColumnAffected;
    }

    public Object getNewValue() {
        return moNewValue;
    }

    public TableProvider getTableProvider() {
        return moTableProvider;
    }



    //----------------------------------------------------------------------------
    // Member variables

    public static final int UNKNOWN_TYPE                = 0;
    public static final int COLUMN_INFO_CHANGED         = 1001;
    public static final int VALUE_CHANGED               = 1002;

    public static final int CURRENT_ROW_NUMBER_CHANGED  = 1003;
    public static final int CURRENT_ROW_CHANGED         = 1004;
    public static final int NON_CURRENT_ROW_CHANGED     = 1005;
    public static final int ROWS_INSERTED               = 1006;
    public static final int ROW_INSERTED                = 1007;
    public static final int ROW_DELETED                 = 1008;
    public static final int TABLE_EMPTY                 = 1009;
    public static final int ALL_CHANGED                 = 1010;
    public static final int NUM_FETCHED                 = 1011;

    private int miChangeType;
    private int miRowAffected;
    private int miColumnAffected;
    private Object moNewValue = null;
    private TableProvider moTableProvider = null;


} // TableChangeeEvent
