/*
 * TableChangeSupport.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */

package netscape.peas;




/**
 * The TableChangeSupport is a helper class to which classes which
 * fire the TableChangeEvent may delegate their implementations of:
 *    AddTableChangeListenter
 *    RemoveTableChangeListener
 *    FireTableChangeListener
 */
public class TableChangeSupport  {


    public TableChangeSupport( Object oDelegator ) {
	    //super( oSourceBean );
	    moDelegator = oDelegator;
    }


    public synchronized void addTableChangeListener( TableChangeListener oListener ) {
        if ( null == mvTableChangeListeners ) {
            mvTableChangeListeners = new java.util.Vector();
        }
        mvTableChangeListeners.addElement( oListener );
    }


    public synchronized void removeTableChangeListener( TableChangeListener oListener ) {
	    if ( null != mvTableChangeListeners ) {
	        mvTableChangeListeners.removeElement( oListener );
	    }
    }

    public void propegateTableChange( TableChangeEvent oEvent ) {
    	java.util.Vector vTargets;
    	synchronized (this) {
    	    if ( mvTableChangeListeners == null) {
    	    	return;
    	    }
    	    vTargets = (java.util.Vector) mvTableChangeListeners.clone();
    	}

    	for ( int i = 0; i < vTargets.size(); i++ ) {
    	    TableChangeListener oTarget = (TableChangeListener)vTargets.elementAt( i );
    	    if ( ! oEvent.isOnVisitedList( oTarget ) ) {
    	        oEvent.addToVisitedList( oTarget );
    	        oTarget.tableChange( oEvent );
    	    } else {
    	        //System.out.println( "Table Change not propegated to " + oTarget + " ... already on list " );
    	    }
    	}

    } // propegateTableChange

    public void fireTableChange( int iChangeType, int iRowAffected, int iColumnAffected, Object oNewValue, TableProvider oTableProvider, NotifyList oNotify ) {

        // create a new TableChagne event with given parameters
        TableChangeEvent oEvent = new TableChangeEvent( iChangeType, iRowAffected, iColumnAffected, oNewValue, oTableProvider );

        // pass along reference notify list
        oEvent.setNotifyList( oNotify );

        // add ourselves to list
        oEvent.addToVisitedList( moDelegator );

        // call listeners (unless theyre already on list)
        propegateTableChange( oEvent );

    }

    //-------------------------------------------------------
    // member variables

    private java.util.Vector mvTableChangeListeners = null;
    private Object moDelegator = null;
}
