/*
 * ShowTextBeanInfo.java    1.0 97/11/09
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * History:
 * v1.0    97/08/28
 * v1.1    97/11/09
 */
package netscape.samples.simple;

import java.beans.SimpleBeanInfo;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.BeanInfo;

// To allow the JavaBean Component to specify
// a help URL for providing end-users with HTML
// documentation (included in the JAR)
import netscape.beans.BeanHelp;


/**
 * Note: Images may be missing from the JavaDocs generated.<p>
 * <b>Do not be alarmed</b>: this is intentional and should
 * not impact the usability of the JavaDocs as a reference.
 */
public class ShowTextBeanInfo extends SimpleBeanInfo
                    implements netscape.beans.BeanHelp {

    private final static Class customizerClass = netscape.samples.simple.ShowTextCustomizer.class;
    private final static Class beanClass = netscape.samples.simple.ShowText.class;

    /**
     * @return  A String containing an URL address (absolute) to an HTML
     * document describing the bean, or null if no help available.
     */
    public String getHelpURL() {
        return("netscape/samples/simple/ShowText_doc.html");
    }


    /**
     * Publishes the properties, methods and events for the
     * ShowText class.
     * <p>
     * In this example, only the message is exposed.  We could
     * omit overriding this method if we wanted to rely on
     * the automatic querying of the ShowText class -- by
     * explicitly publishing methods / properties / events here,
     * we can choose which methods, etc. we really want to expose.
     * @exception java.lang.Exception thrown when introspection fails
     */
    public ShowTextBeanInfo() throws Exception {

        // Publish methods -------------------------------------------------

        _methodDescriptor = new MethodDescriptor[0];

        // Publish properties ----------------------------------------------
        _propertyDescriptor = new PropertyDescriptor[1];

        _propertyDescriptor[0] = new PropertyDescriptor("message",
                                  Class.forName("netscape.samples.simple.ShowText"));

        // Publish events --------------------------------------------------
        _eventSetDescriptor = new EventSetDescriptor[0];

    }

    /**
     * Returns the beanDescriptor and allows us to
     * indicate a customizer class (ShowTextCustomizer)
     */
    public BeanDescriptor getBeanDescriptor() {
        try {
            // We'd return this if we didn't have a customizer
            //return new BeanDescriptor(Class.forName("netscape.samples.simple.ShowText"));

            ///////////////////////////////////////////////////////////
            //
            // Here is where we return the reference to our Custom
            // Property Editor for this bean!
            //
            return new BeanDescriptor(beanClass, customizerClass);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * Returns the icon images
     */
	public java.awt.Image getIcon(int iconType) {
		if (iconType == BeanInfo.ICON_COLOR_16x16) {
				java.awt.Image img = loadImage("ShowTextColor16.gif");
				return img;
		}
		if (iconType == BeanInfo.ICON_COLOR_32x32) {
				java.awt.Image img = loadImage("ShowTextColor32.gif");
				return img;
		}
		if (iconType == BeanInfo.ICON_MONO_16x16) {
				java.awt.Image img = loadImage("ShowTextMono16.gif");
				return img;
		}
		if (iconType == BeanInfo.ICON_MONO_32x32) {
				java.awt.Image img = loadImage("ShowTextMono32.gif");
				return img;
		}
		return null;
	}


    /**
     * Returns the array of EventSetDescriptors
     */
    public EventSetDescriptor[] getEventSetDescriptors() {
        return _eventSetDescriptor;
    }

    /**
     * Returns the array of MethodDescriptors
     */
    public MethodDescriptor[] getMethodDescriptors() {
        return _methodDescriptor;
    }

    /**
     * Returns the array of PropertyDescriptors
     */
    public PropertyDescriptor[] getPropertyDescriptors() {
        return _propertyDescriptor;
    }

    /**
     * No additional BeanInfo has been specified for this
     * bean.
     */
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    private EventSetDescriptor[] _eventSetDescriptor;
    private MethodDescriptor[]   _methodDescriptor;
    private PropertyDescriptor[] _propertyDescriptor;
}
