/*
 * CalendarVisual.java   1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.samples.widgets;

import java.awt.*;

/**
 * This is the class which supplies a custom
 * visual for use by the Calendar JavaScript Bean:
 * <b><a href="./Calendar.jsb">Calendar.jsb</a></b>. (see also
 * the <b><a href="./Calendar_jsb.html">jsbdocs</a></b> for Calendar.jsb).
 *
 */
public class CalendarVisual extends Component
{
     /**
      * Called to draw to component.
      */
     public void paint(Graphics g)
     {
        Dimension size = getSize();
        int width = size.width - 1;
        int height = size.height - 1;

        // Draws a simplified Calendar icon...
        // using the default font
        g.setFont(getFont());
        g.setColor(Color.blue);

        // Semi-centered given our default dimensions
        // of 18x18
        g.drawString("C",5,15);

        // Draw a simple gray embossed-style
        // border
        g.setColor(Color.lightGray);
        g.drawRect(0,0,width-2,height-2);

        g.setColor(Color.darkGray);
        g.drawRect(2,2,width-2,height-2);

        g.setColor(Color.gray);
        g.drawRect(1,1,width-2,height-2);


     }

 /**
  * Lets return our preferred size.
  */
 public Dimension preferredSize()
 {
    return _preferredSize;
 }

 private Dimension _preferredSize = new Dimension(20,20);

}

