<JSB>
/*
 * LayerController.jsb    1.1 97/11/09
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

   /**
    * The LayerController can show and hide a layer,
    * and supports multiple layer controller instances per page...
    */
   <JSB_DESCRIPTOR
        NAME="netscape.samples.simple.LayerController" DISPLAYNAME="Layer Controller"
        HELP_URL="netscape/samples/simple/LayerController_jsb.html">

    
   /**
    * n_s_s_ stands for netscape/samples/simple...
    * allows icon to sit in root of jar.
    */
   <JSB_ICON ICONNAME="n_s_s_LayerController">

   /**
    * The source for the layer defaults to
    * "pagelet.html" which is part of the JAR file
    * this component is packaged in.
    */
   <JSB_PROPERTY NAME="layerSource" TYPE="string"
        DEFAULT_VALUE="netscape/samples/simple/pagelet.html"> 

   <JSB_METHOD NAME="showLayer" TYPE="void"> </JSB_METHOD>

   <JSB_METHOD NAME="hideLayer" TYPE="void"> </JSB_METHOD>

   <JSB_CONSTRUCTOR>

    /**
     * Hides the layer, if it exists.
     */
    function netscape_samples_simple_LayerController_hideLayer() {

        if(this.myLayer != "undefined") {
            this.myLayer.visibility = "hide";
        }

        this.sysout("hide");
    }

    /**
     * Shows the layer.
     * <p>
     * If the layer doesn't exist, this function first creates
     * the layer.
     */
    function netscape_samples_simple_LayerController_showLayer() {
        this.sysout("in showLayer");

        // Check to see if the layer exists.
        // If not, create the layer
        if(this.myLayer == "undefined") {
            this.sysout("mylayer == "+this.myLayer);
            this.createLayer();
            this.sysout("after creation, mylayer == "+this.myLayer);
        }

        this.myLayer.visibility = "show";

    }


    /**
     * A private function (hence the underscore)
     * used to create the layer.
     */
    function _netscape_samples_simple_LayerController_createLayer() {
        this.sysout("in createLayer");
        myLayer = new Layer(350);
        myLayer.height = 200;
        myLayer.clip.height = 200;
        myLayer.clip.width = 350;
        myLayer.pageX = 100;
        myLayer.pageY = 100;
        myLayer.bgColor = "#ffddee";
        myLayer.src = this.layerSource;

        this.sysout("createLayer::this.layerSource = " + this.layerSource);
        this.myLayer = myLayer;

    }

    /**
     * This is another private function.  By default, this
     * component's source is in "non-debug" mode, which
     * means that debugging messages won't appear in the
     * the Java Console.  By uncommenting the call
     * to "java.lang.System.out.println(Str);" -- which
     * is calling the java class "System.out.println" directly
     * from JavaScript -- printing debug messages to the Java Console
     * is re-enabled.
     */
    function _netscape_samples_simple_LayerController_sysout(Str) {
        // Commented out to avoid extra overhead of printing
        // debugging messages

        // java.lang.System.out.println(Str);
    }


    /**
     * Constructs a new LayerController Object, each layerController
     * has one source property.
     */
    function netscape_samples_simple_LayerController(params) {
        this.hideLayer = netscape_samples_simple_LayerController_hideLayer;        // hides
        this.showLayer = netscape_samples_simple_LayerController_showLayer;        // shows

        // Doesn't need to be declared in SGML because
        // it is a private method, but does need to be
        // assigned to this (all methods do, unless they are static,
        // like sysout, which we assign anyway for namespace reasons).
        this.createLayer = _netscape_samples_simple_LayerController_createLayer; 

        this.layerSource = params.layerSource; // the pagelet

        this.sysout = _netscape_samples_simple_LayerController_sysout; // a private function
        this.sysout("LayerController::this.layerSource = " + this.layerSource);

    }

    </JSB_CONSTRUCTOR>
</JSB>
