    /**
     * The constructor simply adds an image-link that pops up a Calendar page in a sep.
     * window, passing to it the datefield.
     * <p>
     * Makes use of a custom visual defined in
     * <b><a href="./CalendarVisual.java">CalendarVisual.java</a></b> (see also
     * the <b><a href="./netscape.samples.widgets.CalendarVisual.html">javadocs</a></b> for CalendarVisual).
     * <p>
     * Outputs an HTML link which triggers a JavaScript function to open
     * and initialize the calendar window with this component acting
     * simply as the "dateController" stub.
     * <p>
     * <b>Most of the logic for the actual calendar operation is in the
     * <i>Pagelet</i> packaged with the component called "calendar.html"
     */
    function netscape_samples_widgets_Calendar(params) {
        // Initialize child window (which gets set when calendar is popped up in
        // a new window -- see the Pagelet "Calendar.html") to null
        this.childWindow = null;

        // Assign private functions too!  This is called by
        // the calendar.html pagelet upon opening and closing
        // so we know whether or not to fire update events to the
        // window (not a good idea when the window doesn't exist ;-)
        this.setWindow = netscape_samples_widgets_Calendar_setWindow;

        this.value=params.value;
        this.setValue=netscape_samples_widgets_Calendar_setValue;
        this.getValue=netscape_samples_widgets_Calendar_getValue;

        // Allows this component to have property-value-change listeners
        this.fireOnChange = netscape_samples_widgets_Calendar_fireOnChange;


        // The following calls output to the document an HTML link which actually
        // triggers a JavaScript function to open and initialize the calendar
        // window with this component acting simply as the "dateController" stub.
        document.writeln("<A HREF=\"#\" onClick=\"window.dateController = "+params.id+";");

        // the name of the window is suffixed with the ID for uniqueness for multiple
        // dateControllers / Calendar Components on a page.
        document.writeln("calendar = window.open('netscape/samples/widgets/calendar.html','cal"+params.id+"','WIDTH=200,HEIGHT=250')\"><IMG");
        document.writeln(" src=\"netscape/samples/widgets/calendar.gif\" border=0></A>");    

    }

    /**
     * If there is an onChange event assigned (this.onChange != null)
     * (this would be done externally, and happens
     * when another component is established as a listener
     * to this component),
     * call our onChange handling code on the property <i>propName</i>
     * with the notification that the property is now
     * <i>newValue</i>
     * <p>
     * Notice that functions contain not just the package namespace but
     * the JSB's name, to avoid namespace pollution.
     * @see setValue
     */
    function netscape_samples_widgets_Calendar_fireOnChange(propName, newValue) {
        if(this.onChange != null) {

            // The null is an optional parameter for the oldValue,
            // we don't retain the old value and it is OK to simply
            // pass null...
            this.onChange(propName, null, newValue);

        }
    }

    /**
     * This method is called by the <b>Calendar.html</b> <i>pagelet</I>
     * when the pagelet's window is shown or closed.
     * Allows the Calendar pagelet to be updated when the value is
     * changed externally (for example, when a user types in a two-way
     * wired textfield). 
     */
    function netscape_samples_widgets_Calendar_setWindow(chWindow) {
        this.childWindow = chWindow;
    }

    /**
     * Getter method allows the value of the dateController stub
     * (this component) to be queried externally.
     * @see setValue
     */
    function netscape_samples_widgets_Calendar_getValue() {
        return this.value;
    }

    /**
     * Receives property change events from the outside world
     * and allows this JSB to function as an event listener as
     * well as an event receiver.
     * @see fireOnChange
     * @see getValue
     */
    function netscape_samples_widgets_Calendar_setValue( sNewValue ) {
        // Don't fire a change event here... If you did,
        // you could potentially get an infinite loop.
        this.value = sNewValue;

        if(this.childWindow != null) {
            this.childWindow.setDate(this.value);
            this.childWindow.focus();

        }
    }

