/*
 * ReadFile.java    1.0 97/11/06
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * -garys
 */
package netscape.samples.jsbdoc; 

import java.io.*;
import java.util.*;

public class ReadFile {

    private static Vector fileLines = new Vector();

    public ReadFile(String fileName) {
        try {
            FileInputStream fis = new java.io.FileInputStream(fileName);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            String line = "";
            while (( line = dis.readLine()) != null) { 
                fileLines.addElement(new String(line));
            }
            fis.close();
        } catch (FileNotFoundException fnfe) {
            System.out.println("class ReadFile can't find file \"" + fileName + "\"\n" + fnfe);
        } catch (IOException ioe) {
            System.out.println("class ReadFile caught i/o exception:\n" + ioe);
        }
    }

    public static Vector getFileLines() {
        return fileLines;
    }

    public static void main(String args[]) {
        try {
            new ReadFile(args[0]);
        } catch (Exception e) {
            System.out.println("usage: ReadFile [filename]");
        }
    }
}
