/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import netscape.nethelp.util.ErrorMsg;
import netscape.nethelp.util.TraceMsg;
import netscape.palomar.htmllite.LiteParser;
import netscape.palomar.sgml.SGMLAttribute;
import netscape.palomar.sgml.SGMLElement;
import netscape.palomar.sgml.SGMLTag;
import netscape.palomar.sgml.SGMLTagImpl;
import netscape.palomar.sgml.SGMLText;
import netscape.palomar.sgml.SGMLTextImpl;
import netscape.palomar.util.CascadedException;
import netscape.palomar.util.TreeEnumeration;

public class HelpTopicPage {
    URL page;
    String pageFilename;
    HelpProject project;

    public HelpTopicPage(HelpProject helpProject, String string) throws MalformedURLException {
        TraceMsg.show("constructing HelpTopicPage for " + string);
        this.page = new URL(String.valueOf(helpProject.getDirectory()) + string);
        this.project = helpProject;
        this.pageFilename = string;
    }

    public void fetchInfo(HelpIndex helpIndex, HelpContents helpContents, Hashtable hashtable, Hashtable hashtable2) {
        HelpTOCHead helpTOCHead = new HelpTOCHead(" - no title - ", null);
        try {
            TraceMsg.show("scanning " + this.page + " for TOC and INDEX strings");
            this.page.toString();
            URLConnection uRLConnection = this.page.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                ErrorMsg.show("Stream is null");
                return;
            }
            SGMLTag sGMLTag = LiteParser.getParser().parseStream(inputStream);
            if (sGMLTag == null) {
                ErrorMsg.show("SGMLTag is null");
                return;
            }
            TreeEnumeration treeEnumeration = new TreeEnumeration(sGMLTag);
            if (treeEnumeration == null) {
                ErrorMsg.show("Tree Enumeration is null");
                return;
            }
            boolean bl = false;
            while (treeEnumeration.hasMoreElements()) {
                int n = 0;
                n = treeEnumeration.getLevelOfElement();
                SGMLElement sGMLElement = (SGMLElement)treeEnumeration.nextElement();
                if (bl) {
                    while (treeEnumeration.getLevelOfElement() > n) {
                        sGMLElement = (SGMLElement)treeEnumeration.nextElement();
                    }
                    bl = false;
                }
                if (!(sGMLElement instanceof SGMLTag)) continue;
                SGMLTagImpl sGMLTagImpl = (SGMLTagImpl)sGMLElement;
                TraceMsg.show("found tag: " + sGMLTagImpl.getRawValue() + " tag tree level = " + treeEnumeration.getLevelOfElement());
                try {
                    if ("A".equals(sGMLTagImpl.getTagType())) {
                        this.gatherTopicInfo(sGMLTagImpl, helpIndex);
                    }
                    if ("H1".equals(sGMLTagImpl.getTagType())) {
                        helpTOCHead = this.createTOCHead(sGMLTagImpl, helpIndex);
                        helpContents.addElement(helpTOCHead);
                        bl = true;
                    }
                    if (!"H2".equals(sGMLTagImpl.getTagType())) continue;
                    this.createTOCSubhead(sGMLTagImpl, helpTOCHead, helpIndex);
                    bl = true;
                }
                catch (Exception exception) {
                    CascadedException.printException(exception, "Scanning the page");
                }
            }
            return;
        }
        catch (Exception exception) {
            CascadedException.printException(exception, "HelpTopicPage.fetchInfo");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HelpTopic gatherTopicInfo(SGMLTagImpl sGMLTagImpl, HelpIndex helpIndex) {
        String string = "";
        String string2 = "";
        String string3 = "";
        HelpTopic helpTopic = null;
        try {
            TreeEnumeration treeEnumeration = new TreeEnumeration(sGMLTagImpl);
            if (treeEnumeration == null) {
                ErrorMsg.show("When parsing HTML, <A> tree enumeration was null");
                return null;
            }
            while (true) {
                if (!treeEnumeration.hasMoreElements()) {
                    SGMLAttribute sGMLAttribute = sGMLTagImpl.getAttribute("NAME");
                    if (sGMLAttribute != null) {
                        string2 = sGMLAttribute.getUnicode();
                    }
                    if ((sGMLAttribute = sGMLTagImpl.getAttribute("TOCSTRING")) != null) {
                        string3 = sGMLAttribute.getUnicode();
                    }
                    helpTopic = new HelpTopic(this.project.getRoot(), this.project.getSubdirectory(), this.pageFilename, string2, string, string3);
                    break;
                }
                SGMLElement sGMLElement = (SGMLElement)treeEnumeration.nextElement();
                if (!(sGMLElement instanceof SGMLText)) continue;
                string = ((SGMLTextImpl)sGMLElement).getUnicode();
            }
        }
        catch (Exception exception) {
            CascadedException.printException(exception, "HelpTopicPage.extractTocItem");
        }
        this.gatherIndexEntries(sGMLTagImpl, helpIndex, helpTopic);
        return helpTopic;
    }

    private void gatherIndexEntries(SGMLTagImpl sGMLTagImpl, HelpIndex helpIndex, HelpTopic helpTopic) {
        try {
            SGMLAttribute sGMLAttribute = sGMLTagImpl.getAttribute("INDEXSTRING");
            if (sGMLAttribute != null && helpIndex != null) {
                int n;
                String string = sGMLAttribute.getUnicode();
                int n2 = 0;
                do {
                    String string2;
                    if ((n = string.indexOf(94, n2)) == -1) {
                        string2 = string.substring(n2);
                    } else {
                        string2 = string.substring(n2, n);
                        n2 = n + 1;
                    }
                    helpIndex.put(string2, helpTopic);
                    TraceMsg.show("Added entry to index: " + string2);
                } while (n != -1);
                return;
            }
        }
        catch (Exception exception) {
            CascadedException.printException(exception, "HelpTopicPage.gatherIndexEntries");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HelpTOCHead createTOCHead(SGMLTagImpl sGMLTagImpl, HelpIndex helpIndex) {
        String string = "";
        HelpTOCHead helpTOCHead = null;
        try {
            TreeEnumeration treeEnumeration = new TreeEnumeration(sGMLTagImpl);
            if (treeEnumeration == null) {
                ErrorMsg.show("H<> Tree Enumeration is null");
                return null;
            }
            while (true) {
                SGMLTagImpl sGMLTagImpl2;
                if (!treeEnumeration.hasMoreElements()) {
                    return helpTOCHead;
                }
                SGMLElement sGMLElement = (SGMLElement)treeEnumeration.nextElement();
                if (!(sGMLElement instanceof SGMLTag) || !"A".equals((sGMLTagImpl2 = (SGMLTagImpl)sGMLElement).getTagType())) continue;
                HelpTopic helpTopic = this.gatherTopicInfo(sGMLTagImpl2, helpIndex);
                helpTOCHead = new HelpTOCHead(string, helpTopic);
            }
        }
        catch (Exception exception) {
            CascadedException.printException(exception, "HelpTopicPage.processTagH");
        }
        return helpTOCHead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTOCSubhead(SGMLTagImpl sGMLTagImpl, HelpTOCHead helpTOCHead, HelpIndex helpIndex) {
        String string = "";
        String string2 = "";
        HelpTopic helpTopic = null;
        HelpTOCItem helpTOCItem = null;
        try {
            TreeEnumeration treeEnumeration = new TreeEnumeration(sGMLTagImpl);
            if (treeEnumeration == null) {
                ErrorMsg.show("H<> Tree Enumeration is null");
                return;
            }
            while (true) {
                if (!treeEnumeration.hasMoreElements()) {
                    return;
                }
                SGMLElement sGMLElement = (SGMLElement)treeEnumeration.nextElement();
                if (sGMLElement instanceof SGMLTag) {
                    SGMLTagImpl sGMLTagImpl2 = (SGMLTagImpl)sGMLElement;
                    if (!"A".equals(sGMLTagImpl2.getTagType())) continue;
                    helpTopic = this.gatherTopicInfo(sGMLTagImpl2, helpIndex);
                    TraceMsg.show("CreateTOCSubhead (h2) \n\tTEXT = " + helpTopic.getTitle() + "\n\tTOCSTRING = " + helpTopic.getContentsName() + "\n\tNAME = " + helpTopic.getTopic());
                    if (string2 != null && helpTopic.getTitle().length() == 0) {
                        helpTopic.setTitle(string2);
                        TraceMsg.show("Anchor text was empty; using preceding text from header tag: " + string2);
                    }
                    if ((helpTOCItem = new HelpTOCItem(string, helpTopic)) == null) continue;
                    helpTOCHead.addElement(helpTOCItem);
                    continue;
                }
                if (!(sGMLElement instanceof SGMLText)) continue;
                string2 = ((SGMLTextImpl)sGMLElement).getUnicode().trim();
                if (string2.length() == 0) {
                    string2 = null;
                    continue;
                }
                if (helpTopic == null || helpTopic.getTitle().length() != 0) continue;
                helpTopic.setTitle(string2);
                TraceMsg.show("Preceding anchor text was empty; using text from header tag: " + string2);
            }
        }
        catch (Exception exception) {
            CascadedException.printException(exception, "HelpTopicPage.processTagH");
            return;
        }
    }
}

