# Generated by default/object.tt
package Paws::CloudFormation::StackInstanceComprehensiveStatus;
  use Moose;
  has DetailedStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::StackInstanceComprehensiveStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::StackInstanceComprehensiveStatus object:

  $service_obj->Method(Att1 => { DetailedStatus => $value, ..., DetailedStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::StackInstanceComprehensiveStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->DetailedStatus

=head1 DESCRIPTION

The detailed status of the stack instance.

=head1 ATTRIBUTES


=head2 DetailedStatus => Str

=over

=item *

C<CANCELLED>: The operation in the specified account and Region has
been cancelled. This is either because a user has stopped the stack set
operation, or because the failure tolerance of the stack set operation
has been exceeded.

=item *

C<FAILED>: The operation in the specified account and Region failed. If
the stack set operation fails in enough accounts within a Region, the
failure tolerance for the stack set operation as a whole might be
exceeded.

=item *

C<INOPERABLE>: A C<DeleteStackInstances> operation has failed and left
the stack in an unstable state. Stacks in this state are excluded from
further C<UpdateStackSet> operations. You might need to perform a
C<DeleteStackInstances> operation, with C<RetainStacks> set to C<true>,
to delete the stack instance, and then delete the stack manually.

=item *

C<PENDING>: The operation in the specified account and Region has yet
to start.

=item *

C<RUNNING>: The operation in the specified account and Region is
currently in progress.

=item *

C<SUCCEEDED>: The operation in the specified account and Region
completed successfully.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

