#! /usr/bin/perl -w
################################################################################
#
# recvar.t (Test recursive variable names)
#
################################################################################
#
# Includes
#
################################################################################
use strict;
use Test;
################################################################################
#
# Setup
#
################################################################################
BEGIN {
	plan test => 3
} use PML;
################################################################################
#
# Start
#
################################################################################
my ($parser, @code, $output);

$parser = new PML;
@code = <DATA>;
$parser->parse(\@code); ok(1);
$output = $parser->execute;

if ($output =~ /0/) {
	ok(0);
} else {
	ok(1);
}

ok($output =~ /11/ and $output =~ /23/);
################################################################################
#                              END-OF-SCRIPT                                   #
################################################################################
__END__
@set ( a    , x )
@set ( b    , y )
@set ( xy   , 11)
@set ( x-y  , 23)

${${a}${b}}
${${a}-${b}}


