/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.layering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.hector2.MinMax;
import net.sourceforge.plantuml.hector2.mpos.MutationLayer;
import net.sourceforge.plantuml.hector2.mpos.MutationLayerMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer {
    private final int id;
    private final Map<IEntity, Integer> entities = new HashMap<IEntity, Integer>();

    public Layer(int n) {
        this.id = n;
    }

    public Layer duplicate() {
        Layer layer = new Layer(this.id);
        layer.entities.putAll(this.entities);
        return layer;
    }

    public List<MutationLayer> getPossibleMutations() {
        ArrayList<MutationLayerMove> arrayList = new ArrayList<MutationLayerMove>();
        for (Map.Entry<IEntity, Integer> entry : this.entities.entrySet()) {
            IEntity iEntity = entry.getKey();
            int n = entry.getValue();
            if (this.isLongitudeFree(n + 2)) {
                arrayList.add(new MutationLayerMove(this, iEntity, n + 2));
            }
            if (!this.isLongitudeFree(n - 2)) continue;
            arrayList.add(new MutationLayerMove(this, iEntity, n - 2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private boolean isLongitudeFree(int n) {
        return !this.entities.values().contains(n);
    }

    public void put(IEntity iEntity, int n) {
        if (!this.entities.containsKey(iEntity)) {
            throw new IllegalArgumentException();
        }
        this.entities.put(iEntity, n);
    }

    public void add(IEntity iEntity) {
        int n = this.entities.size() * 2;
        this.entities.put(iEntity, n);
    }

    public Collection<IEntity> entities() {
        return Collections.unmodifiableCollection(this.entities.keySet());
    }

    public int getLongitude(IEntity iEntity) {
        return this.entities.get(iEntity);
    }

    public MinMax getMinMaxLongitudes() {
        return MinMax.from(this.entities.values());
    }

    public String toString() {
        return "layer " + this.id + " " + this.entities;
    }

    public final int getId() {
        return this.id;
    }
}

