package Bundle::Padre::Plugin;

use 5.0106;
use strict;
use warnings FATAL => 'all';

=head1 NAME

Bundle::Padre::Plugin - A Bundle of Padre::Plugins currently on CPAN.

=head1 VERSION

Version 0.011

=cut

our $VERSION = '0.011';


=head1 SYNOPSIS

This module is intended to allow for the easy installation of all 
currently-available Padre::Plugin::* modules on CPAN. (2013-10-28)


=head1 CONTENTS

	Padre::Plugin

	Padre::Plugin::Alarm 

	Padre::Plugin::Autodia 

	Padre::Plugin::Autoformat 

	Padre::Plugin::CSS 

	Padre::Plugin::CSSComb

	Padre::Plugin::Catalyst 

	Padre::Plugin::ClassSniff

	Padre::Plugin::CommandLine 

	Padre::Plugin::Cookbook 

	Padre::Plugin::DataWalker 

	Padre::Plugin::Debugger 

	Padre::Plugin::Devel 

	Padre::Plugin::DistZilla 

	Padre::Plugin::Ecliptic 

	Padre::Plugin::Encode 

	Padre::Plugin::Encrypt 

	Padre::Plugin::Filter 

	Padre::Plugin::FormBuilder 

	Padre::Plugin::Git 

	Padre::Plugin::HG 

	Padre::Plugin::HTML 

	Padre::Plugin::InstallPARDist 

	Padre::Plugin::JavaScript 

	Padre::Plugin::Kate 

	Padre::Plugin::LaTeX

	Padre::Plugin::Mojolicious 

	Padre::Plugin::Moose 

	Padre::Plugin::NYTProf 

	Padre::Plugin::Nopaste 

	Padre::Plugin::PAR 

	Padre::Plugin::PDL 

	Padre::Plugin::PHP 

	Padre::Plugin::Parrot 

	Padre::Plugin::ParserTool 

	Padre::Plugin::Perl6 

	Padre::Plugin::PerlCritic 

	Padre::Plugin::PerlTidy 

	Padre::Plugin::Plack 

	Padre::Plugin::PopularityContest 

	Padre::Plugin::REPL 

	Padre::Plugin::RegexExplain 

	Padre::Plugin::RunPerlExternal 

	Padre::Plugin::SVN 

	Padre::Plugin::Shell 

	Padre::Plugin::ShellCommand 

	Padre::Plugin::ShellScript 

	Padre::Plugin::Shopify 

	Padre::Plugin::Snippet 

	Padre::Plugin::SpellCheck 

	Padre::Plugin::Swarm 

	Padre::Plugin::Template 

	Padre::Plugin::Vi 

	Padre::Plugin::ViewInBrowser 

	Padre::Plugin::WebGUI 

	Padre::Plugin::WxWidgets 

	Padre::Plugin::XML 

	Padre::Plugin::XS 

	Padre::Plugin::YAML 

	Module::Install::PadrePlugin

=head1 AUTHOR

Albert Croft, C<< <atcroft at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-bundle-padre-plugin at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Bundle-Padre-Plugin>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Bundle::Padre::Plugin


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Bundle-Padre-Plugin>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Bundle-Padre-Plugin>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Bundle-Padre-Plugin>

=item * Search CPAN

L<http://search.cpan.org/dist/Bundle-Padre-Plugin/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2013 Albert Croft.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of Bundle::Padre::Plugin
