use strict;
use warnings;

use Test::More;

my $layout_to_test = 'FixedDimension';

use_ok('CSS::SpriteMaker');

my $SpriteMaker = CSS::SpriteMaker->new();

my $rh_source_info = $SpriteMaker->_ensure_sources_info(
    source_images => ['sample_icons/']
);

my $Layout = $SpriteMaker->_ensure_layout(
    layout => {
        name => 'FixedDimension',
        options => {
            'n' => 3
        }
    },
    rh_sources_info => $rh_source_info
);

my $ascii_string = $Layout->get_layout_ascii_string({
    canvas_width => 100,
    canvas_height => 80,
    rh_item_info => $rh_source_info
});

# my $ascii_string_expected = <<'EOF';
# |.33+++++++.32+++++++.21+++++++                              |
# |+++++++++o++++++++++++++++++++                              |
# |          +++++++++o+++++++++o                              |
# |.7++++++++.26+++++++.17+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.2++++++++.1++++++++.18+++++                                |
# |++++++++++++++++++++++++++++                                |
# |+++++++++o+++++++++o+++++++o                                |
# |.30++++.16+++++++.44++++                                    |
# |++++++++++++++++++++++++                                    |
# |++++++o+++++++++o++++++o                                    |
# |.27+++++++.25+++++++.28+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.40++++++.20+++++++++++++++++                               |
# |+++++++++++++++++++++++++++++                               |
# |++++++++o++++++++++o++++++++o                               |
# |.24+++++++.10+++++++.31+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.35+++++++.11++++++.48+++++++                               |
# |+++++++++++++++++++++++++++++                               |
# |+++++++++o++++++++o+++++++++o                               |
# |.42+++++++.22+++++++.46+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.0++++++++.13+++++++.23++++                                 |
# |+++++++++o+++++++++++++++++                                 |
# |          +++++++++o++++++o                                 |
# |.29+++++++.6++++++++.39+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.36+++++++.3++++++++.9++++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.41+++++++.12+++++++.47+++++++                              |
# |++++++++++++++++++++++++++++++                              |
# |+++++++++o+++++++++o+++++++++o                              |
# |.15++++.38+++++.8++++++++                                   |
# |+++++++++++++++++++++++++                                   |
# |++++++o+++++++o+++++++++o                                   |
# |.4++++++++.34++++++.45+++++++                               |
# |+++++++++++++++++++++++++++++                               |
# |+++++++++o++++++++o+++++++++o                               |
# |.37+++++++++++++++++++++++++++++++++++++.43+++++++.19+++++++|
# |++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|
# |+++++++++++++++++++++++++++++++++++++++++++++++++o+++++++++o|
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |++++++++++++++++++++++++++++++++++++++++                    |
# |+++++++++++++++++++++++++++++++++++++++o                    |
# |.5++++++++                                                  |
# |++++++++++                                                  |
# |+++++++++o                                                  |
# EOF

my @lines_with_dot = grep { $_ =~ m/[.]/ } split ("\n", $ascii_string);
my $last_line = pop @lines_with_dot;

my $fail = 0;

# all lines should have 3 dots
for my $line (@lines_with_dot) {
    my $number_of_dots = () = $line =~ m/[.]/g;
    if ($number_of_dots != 3) {
        $fail = 1;
    }
}

my $number_of_dots_last_line = () = $last_line =~ m/[.]/g;
if ($number_of_dots_last_line != 1) {
   $fail = 1; 
}

if ($fail) {
    fail('layout is as expected');
    diag("we expect three dots per line except for the last one. Got this instead:\n" . $ascii_string);
}
else {
    pass('layout is as expected');
}


done_testing();
