
use strict;
use warnings;

use Module::Build 0.35;
use lib qw{inc}; use Dist::Zilla::LocaleTextDomainBuild;

my %module_build_args = (
  "build_requires" => {
    "App::Cmd::Tester::CaptureExternal" => 0,
    "Dist::Zilla::App::Tester" => 0,
    "Module::Build" => "0.35",
    "Test::DZil" => 0,
    "Test::File" => 0,
    "Test::File::Contents" => 0,
    "Test::More" => "0.90"
  },
  "configure_requires" => {
    "ExtUtils::MakeMaker" => "6.30",
    "Module::Build" => "0.35"
  },
  "dist_abstract" => "Tools for managing Locale::TextDomain language catalogs",
  "dist_author" => [
    "David E. Wheeler <david\@justatheory.com>"
  ],
  "dist_name" => "Dist-Zilla-LocaleTextDomain",
  "dist_version" => "0.85",
  "license" => "perl",
  "module_name" => "Dist::Zilla::LocaleTextDomain",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Dist::Zilla::App" => 0,
    "Dist::Zilla::File::FromCode" => 0,
    "Dist::Zilla::Role::FileGatherer" => 0,
    "Email::Address" => 0,
    "Encode" => 0,
    "File::Basename" => 0,
    "File::Copy" => 0,
    "File::Find::Rule" => 0,
    "File::Path" => "2.07",
    "File::Temp" => 0,
    "IPC::Cmd" => 0,
    "IPC::Run3" => 0,
    "Locale::Country" => 0,
    "Locale::Language" => 0,
    "Moose" => 0,
    "Moose::Role" => 0,
    "Moose::Util::TypeConstraints" => 0,
    "MooseX::Types::Path::Class" => 0,
    "Path::Class" => 0,
    "namespace::autoclean" => 0,
    "perl" => "v5.8.5",
    "strict" => 0,
    "warnings" => 0
  },
  "script_files" => []
);


my $build = Dist::Zilla::LocaleTextDomainBuild->new(%module_build_args);

$build->create_build_script;
