# Generated by default/object.tt
package Paws::ComputeOptimizer::InstanceRecommendationOption;
  use Moose;
  has InstanceType => (is => 'ro', isa => 'Str', request_name => 'instanceType', traits => ['NameInRequest']);
  has PerformanceRisk => (is => 'ro', isa => 'Num', request_name => 'performanceRisk', traits => ['NameInRequest']);
  has PlatformDifferences => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'platformDifferences', traits => ['NameInRequest']);
  has ProjectedUtilizationMetrics => (is => 'ro', isa => 'ArrayRef[Paws::ComputeOptimizer::UtilizationMetric]', request_name => 'projectedUtilizationMetrics', traits => ['NameInRequest']);
  has Rank => (is => 'ro', isa => 'Int', request_name => 'rank', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::InstanceRecommendationOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::InstanceRecommendationOption object:

  $service_obj->Method(Att1 => { InstanceType => $value, ..., Rank => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::InstanceRecommendationOption object:

  $result = $service_obj->Method(...);
  $result->Att1->InstanceType

=head1 DESCRIPTION

Describes a recommendation option for an Amazon EC2 instance.

=head1 ATTRIBUTES


=head2 InstanceType => Str

The instance type of the instance recommendation.


=head2 PerformanceRisk => Num

The performance risk of the instance recommendation option.

Performance risk indicates the likelihood of the recommended instance
type not meeting the resource needs of your workload. Compute Optimizer
calculates an individual performance risk score for each specification
of the recommended instance, including CPU, memory, EBS throughput, EBS
IOPS, disk throughput, disk IOPS, network throughput, and network PPS.
The performance risk of the recommended instance is calculated as the
maximum performance risk score across the analyzed resource
specifications.

The value ranges from C<0> to C<5>, with C<0> meaning that the
recommended resource is predicted to always provide enough hardware
capability. The higher the performance risk is, the more likely you
should validate whether the recommendation will meet the performance
requirements of your workload before migrating your resource.


=head2 PlatformDifferences => ArrayRef[Str|Undef]

Describes the configuration differences between the current instance
and the recommended instance type. You should consider the
configuration differences before migrating your workloads from the
current instance to the recommended instance type. The Change the
instance type guide for Linux
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html)
and Change the instance type guide for Windows
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html)
provide general guidance for getting started with an instance
migration.

Platform differences include:

=over

=item *

B<C<Hypervisor> > E<mdash> The hypervisor of the recommended instance
type is different than that of the current instance. For example, the
recommended instance type uses a Nitro hypervisor and the current
instance uses a Xen hypervisor. The differences that you should
consider between these hypervisors are covered in the Nitro Hypervisor
(http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor) section of the
Amazon EC2 frequently asked questions. For more information, see
Instances built on the Nitro System
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances)
in the I<Amazon EC2 User Guide for Linux>, or Instances built on the
Nitro System
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances)
in the I<Amazon EC2 User Guide for Windows>.

=item *

B<C<NetworkInterface> > E<mdash> The network interface of the
recommended instance type is different than that of the current
instance. For example, the recommended instance type supports enhanced
networking and the current instance might not. To enable enhanced
networking for the recommended instance type, you will need to install
the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual
Function driver. For more information, see Networking and storage
features
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage)
and Enhanced networking on Linux
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html)
in the I<Amazon EC2 User Guide for Linux>, or Networking and storage
features
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage)
and Enhanced networking on Windows
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html)
in the I<Amazon EC2 User Guide for Windows>.

=item *

B<C<StorageInterface> > E<mdash> The storage interface of the
recommended instance type is different than that of the current
instance. For example, the recommended instance type uses an NVMe
storage interface and the current instance does not. To access NVMe
volumes for the recommended instance type, you will need to install or
upgrade the NVMe driver. For more information, see Networking and
storage features
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage)
and Amazon EBS and NVMe on Linux instances
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html)
in the I<Amazon EC2 User Guide for Linux>, or Networking and storage
features
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage)
and Amazon EBS and NVMe on Windows instances
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html)
in the I<Amazon EC2 User Guide for Windows>.

=item *

B<C<InstanceStoreAvailability> > E<mdash> The recommended instance type
does not support instance store volumes and the current instance does.
Before migrating, you might need to back up the data on your instance
store volumes if you want to preserve them. For more information, see
How do I back up an instance store volume on my Amazon EC2 instance to
Amazon EBS?
(https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/)
in the I<AWS Premium Support Knowledge Base>. For more information, see
Networking and storage features
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage)
and Amazon EC2 instance store
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html)
in the I<Amazon EC2 User Guide for Linux>, or see Networking and
storage features
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage)
and Amazon EC2 instance store
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html)
in the I<Amazon EC2 User Guide for Windows>.

=item *

B<C<VirtualizationType> > E<mdash> The recommended instance type uses
the hardware virtual machine (HVM) virtualization type and the current
instance uses the paravirtual (PV) virtualization type. For more
information about the differences between these virtualization types,
see Linux AMI virtualization types
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html)
in the I<Amazon EC2 User Guide for Linux>, or Windows AMI
virtualization types
(https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types)
in the I<Amazon EC2 User Guide for Windows>.

=back



=head2 ProjectedUtilizationMetrics => ArrayRef[L<Paws::ComputeOptimizer::UtilizationMetric>]

An array of objects that describe the projected utilization metrics of
the instance recommendation option.

The C<Cpu> and C<Memory> metrics are the only projected utilization
metrics returned. Additionally, the C<Memory> metric is returned only
for resources that have the unified CloudWatch agent installed on them.
For more information, see Enabling Memory Utilization with the
CloudWatch Agent
(https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).


=head2 Rank => Int

The rank of the instance recommendation option.

The top recommendation option is ranked as C<1>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

