# Generated by default/object.tt
package Paws::ECRPublic::ImageTagDetail;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has ImageDetail => (is => 'ro', isa => 'Paws::ECRPublic::ReferencedImageDetail', request_name => 'imageDetail', traits => ['NameInRequest']);
  has ImageTag => (is => 'ro', isa => 'Str', request_name => 'imageTag', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECRPublic::ImageTagDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECRPublic::ImageTagDetail object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., ImageTag => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECRPublic::ImageTagDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

An object representing the image tag details for an image.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The time stamp indicating when the image tag was created.


=head2 ImageDetail => L<Paws::ECRPublic::ReferencedImageDetail>

An object that describes the details of an image.


=head2 ImageTag => Str

The tag associated with the image.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECRPublic>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

