# Generated by default/object.tt
package Paws::Lightsail::ContainerServiceHealthCheckConfig;
  use Moose;
  has HealthyThreshold => (is => 'ro', isa => 'Int', request_name => 'healthyThreshold', traits => ['NameInRequest']);
  has IntervalSeconds => (is => 'ro', isa => 'Int', request_name => 'intervalSeconds', traits => ['NameInRequest']);
  has Path => (is => 'ro', isa => 'Str', request_name => 'path', traits => ['NameInRequest']);
  has SuccessCodes => (is => 'ro', isa => 'Str', request_name => 'successCodes', traits => ['NameInRequest']);
  has TimeoutSeconds => (is => 'ro', isa => 'Int', request_name => 'timeoutSeconds', traits => ['NameInRequest']);
  has UnhealthyThreshold => (is => 'ro', isa => 'Int', request_name => 'unhealthyThreshold', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServiceHealthCheckConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServiceHealthCheckConfig object:

  $service_obj->Method(Att1 => { HealthyThreshold => $value, ..., UnhealthyThreshold => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServiceHealthCheckConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->HealthyThreshold

=head1 DESCRIPTION

Describes the health check configuration of an Amazon Lightsail
container service.

=head1 ATTRIBUTES


=head2 HealthyThreshold => Int

The number of consecutive health checks successes required before
moving the container to the C<Healthy> state. The default value is
C<2>.


=head2 IntervalSeconds => Int

The approximate interval, in seconds, between health checks of an
individual container. You can specify between 5 and 300 seconds. The
default value is C<5>.


=head2 Path => Str

The path on the container on which to perform the health check. The
default value is C</>.


=head2 SuccessCodes => Str

The HTTP codes to use when checking for a successful response from a
container. You can specify values between 200 and 499.


=head2 TimeoutSeconds => Int

The amount of time, in seconds, during which no response means a failed
health check. You can specify between 2 and 60 seconds. The default
value is C<2>.


=head2 UnhealthyThreshold => Int

The number of consecutive health check failures required before moving
the container to the C<Unhealthy> state. The default value is C<2>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

