
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Plugin to verify pod coverage in our app routes.",
  "AUTHOR" => "Dinis Rebolo <drebolo\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Dancer2-Plugin-RoutePodCoverage",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Dancer2::Plugin::RoutePodCoverage",
  "PREREQ_PM" => {
    "Dancer2" => "0.09",
    "Pod::Simple::Search" => "3.28",
    "Pod::Simple::SimpleTree" => "3.28"
  },
  "TEST_REQUIRES" => {
    "Test::NoWarnings" => 0,
    "Test::Pod" => 0,
    "Test::Pod::Coverage" => 0
  },
  "VERSION" => "0.06",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Dancer2" => "0.09",
  "Pod::Simple::Search" => "3.28",
  "Pod::Simple::SimpleTree" => "3.28",
  "Test::NoWarnings" => 0,
  "Test::Pod" => 0,
  "Test::Pod::Coverage" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



