use strict;
use warnings;

use Test::More tests => 481;
BEGIN { use_ok('Image::PNG::Rewriter') };

my $test = {'w1h1c3d2.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010203000000627b2c1a00000003504c54459999997ce8a41600000001624b47440088051d48000000097048597300000048000000480046c96b3e0000000a4944415408d76360000000020001e221bc330000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 2,'height' => 1},'w512h1c0d2.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 129,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000000010200000000c760510b00000002624b47440001dd8a13a4000000097048597300000048000000480046c96b3e000000184944415408d763080d0d0d5bb56ad552209d05a4e9ce0500b5a43ef1a0b95c1f0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 2,'height' => 1},'w512h256c0d2.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 129,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000200000000aa4b891a00000002624b47440001dd8a13a4000000097048597300000048000000480046c96b3e000000db4944415478daedd63115c3400c444193948b40089f4070e14519a1b86da6d13e7553fe6b66ee24cfee77f7f87b01000000000000ec79f7f9ecfe768fbf00000000000000fd1e0000000000000048bb0700000000000000a6dd030000000000000069f700000000000000c0b47b0000000000000020ed1e0000000000000098760f00000000000000a4dd0300000000000000d3ee0100000000000080b47b0000000000000060da3d0000000000000090760f000000000000004cbb0700000000000000d2ee010000000000008069f70000000000000040ca3df0073442b8522daf6b0b0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 2,'height' => 256},'w512h256c2d16.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 3073,'mode' => 2,'scanline_delta' => 6,'data' => '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','depth' => 16,'height' => 256},'w512h1c0d1.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 65,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000020000000001010000000080c02bdb00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000c4944415408d763f84f21000018993fc1378f75440000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 1,'height' => 1},'w1h1c0d1.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010100000000376ef92400000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000a4944415408d76368000000820081dd436af40000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 1,'height' => 1},'w512h256c2d8.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 1537,'mode' => 2,'scanline_delta' => 3,'data' => '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','depth' => 8,'height' => 256},'w512h1c4d16.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 2049,'mode' => 4,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d4948445200000200000000011004000000522202be00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000002d4944415448c7639c39f3ff7f0632c1d9b3e4ea64603036265fefa8bda3f68eda3b6aefa8bda3f68eda4b99bd00746625325a189d990000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w512h256c0d4.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 257,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000400000000250b7cba00000002624b47440009d3519b96000000097048597300000048000000480046c96b3e000001784944415478daedd9b109c0300c04404f1bf042866c9bc2dfa713029d2b0b35e2cafff5de779efbc68dabcb210000000000000000000000000000a012209f9dc5b81140974300000000000000000000000000a014209f93c5b81140974300000000000000000000000000403b2c10010000000000000000000000000000da6181080000000000000000000000000000d00e0b44000000000000000000000000000080765820020000000000000000000000000000b4c302110000000000000000000000000000a01d1688000000000000000000000000000000edb040040000000000000000000000000000688705220000743904000000000000000000008062807c7616e346005d0e0100000000000000000000000000edb040040000000000000000000000000000688705220000000000000000000000000000403b2c10010000000000000000000000000000da6181080000000000000000000000000000d00e0b4400000000000000000000000000008076f86ffc0099e79dc2622050320000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 4,'height' => 256},'w512h1c3d8.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 513,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000002000000000108030000009f65e64400000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000134944415428cf636040058ca8605476b8cb0200fb070100fc3782140000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w512h256c4d8.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 1025,'mode' => 4,'scanline_delta' => 2,'data' => '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','depth' => 8,'height' => 256},'w512h1c3d1.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 65,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000002000000000101030000009275843500000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e0000001b4944415408d7636060fcff8781fdff0706f9ff0718eaff93cc0500dab71f35ccf04e120000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 1,'height' => 1},'w512h1c3d2.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 129,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000000010203000000d5d5fee500000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000174944415408d763606060600c0d0d0d00d2a2409aee5c00ffbf147155e532860000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 2,'height' => 1},'w1h256c3d1.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000100010300000048f08edb00000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000134944415418d36360c00b1af0c251bd435e2f0042043c81b34a69b70000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 1,'height' => 256},'w512h256c6d16.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 4097,'mode' => 6,'scanline_delta' => 8,'data' => '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','depth' => 16,'height' => 256},'w1h256c4d16.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],'scanline_width' => 5,'mode' => 4,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d494844520000000100000100100400000088a7085000000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000002f4944415438cb639839f3ff7f2606060606ca89b367a9610a0303030393b131d58c1a75d5a8ab465d35ea2aecae0200696916c98923896a0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 16,'height' => 256},'w512h256c4d16.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 2049,'mode' => 4,'scanline_delta' => 4,'data' => '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','depth' => 16,'height' => 256},'w512h1c0d16.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 1025,'mode' => 0,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d4948445200000200000000011000000000dd4095e900000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000174944415438cb63988917a4e105a37a47f58eea1dda7a013433fe7604c7fc080000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h256c0d4.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000100040000000092a5ae4500000002624b47440009d3519b96000000097048597300000048000000480046c96b3e000000144944415418d36398c0800f26e085a37a87bc5e007267795109f34e430000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 4,'height' => 256},'w512h1c2d16.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 3073,'mode' => 2,'scanline_delta' => 6,'data' => '89504e470d0a1a0a0000000d494844520000020000000001100200000077495d6200000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e000000364944415448c7edce311100300cc3c00693d10a94390543876c1200dd0f00bc83dab6bd382749a259b366cd9a356bd6ac59b3e65ff3027d3e69989f22deda0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h1c0d8.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000000010000000108000000003a7e9b5500000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000a4944415408d763980900009b009a07a050f60000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w1h256c0d8.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000000010000010008000000005755434400000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000144944415418d36398c9800fa6e185a37a87bc5e00097480e6dd626f8a0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w512h256c6d8.png' => {'width' => 512,'original_filters' => [1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4],'scanline_width' => 2049,'mode' => 6,'scanline_delta' => 4,'data' => '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','depth' => 8,'height' => 256},'w1h1c3d8.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000001080300000028cb34bb00000003504c54459999997ce8a41600000001624b47440088051d48000000097048597300000048000000480046c96b3e0000000a4944415408d76360000000020001e221bc330000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w1h256c2d16.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3],'scanline_width' => 7,'mode' => 2,'scanline_delta' => 6,'data' => '89504e470d0a1a0a0000000d4948445200000001000001001002000000adcc578c00000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e000000354944415438cbedcf310d00400cc340abcf223482366c9f41b76e993c5a479224030087799224dd8fc6b6ed8a2aaaa8a28a2a5a441fc40314aaff2ece1b0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 16,'height' => 256},'w1h1c0d2.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000001020000000070ce83f400000002624b47440001dd8a13a4000000097048597300000048000000480046c96b3e0000000a4944415408d7637000000042004183b9ecad0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 2,'height' => 1},'w512h1c6d16.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 4097,'mode' => 6,'scanline_delta' => 8,'data' => '89504e470d0a1a0a0000000d4948445200000200000000011006000000f82bca3500000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e0000003d4944415458c3edcf411100400cc2c09e26d4220a4d3d17f49318c8ecb36d7b77ca2549d2bece4892d4ffe2c58b172f5ebc78f1e2c58b172f5ebc97de0f29466b96e77cf5ab0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h256c3d2.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000000010000010002030000000f50f40b00000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000134944415418d36360c00b1cf0c251bd435e2f0022021e4110d2b94b0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 2,'height' => 256},'w1h256c3d4.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000001000001000403000000801001ab00000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000134944415418d36360c00b04f0c251bd435e2f0089f90791c0feb5050000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 4,'height' => 256},'w512h1c2d8.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 1537,'mode' => 2,'scanline_delta' => 3,'data' => '89504e470d0a1a0a0000000d494844520000020000000001080200000027d9812100000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e000000264944415438cb639c39732603d1e0ecd9b3c42b3636361e3579d4e45193474d1e3579d09a0c00728034cdb3c8bb0a0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w512h256c3d2.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 129,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000203000000b8fe26f400000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000dd4944415478daedd6b19102401003416110c2e743081828ff547ea340066ddca9d66b7392e4d1f67dfb77bb380100000000007e1d70dfe78ee7edebf6eb27000000000000c0bd5f0f1200000000008039a0eb1e00000000000000c8ba0700000000000000baee0100000000000080ac7b00000000000000a0eb1e00000000000000c8ba0700000000000000baee0100000000000080ac7b00000000000000a0eb1e00000000000000c8ba0700000000000000baee0100000000000080ac7b00000000000000a0eb1e00000000000000c8ba07000000000000003aee817f8c1335dcaa3ee06e0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 2,'height' => 256},'w1h1c6d8.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 5,'mode' => 6,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d49484452000000010000000108060000001f15c48900000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e0000000d4944415408d763983973e67f00066502cb44249abe0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w1h1c6d16.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 9,'mode' => 6,'scanline_delta' => 8,'data' => '89504e470d0a1a0a0000000d49484452000000010000000110060000004f8518ca00000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e000000124944415408d763983973e6cc9933ffff070016bf059514a915a60000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h256c0d2.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000000010000010002000000001de55be500000002624b47440001dd8a13a4000000097048597300000048000000480046c96b3e000000144944415418d3637060c0071bf0c251bd435e2f0025c25e410b7d1a1b0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 2,'height' => 256},'w1h1c4d8.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 3,'mode' => 4,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010804000000b51c0c0200000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000b4944415408d76398f91f0002340199e86909300000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w512h256c0d8.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 513,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000800000000e0fb91bb00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000002e94944415478daeddaa1110021100441a225a7cf168d463cc5f4d9362746eef8f69bfbd1d775dcfa1815001500150015001500150015001500150015001500150015003d0de09a4fe82f2a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20aef6007115405c05105701c455007115405c05105701c455007115405c05105701c455007115405c0510577b80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab3d405c05105701c455007115405c05105701c455007115405c05105701c455007115405c05105701c4d51e20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e26a0f105701c455007115405c05105701c455007115405c05105701c455007115405c05105701c4550071b50788ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b8da03c455007115405c05105701c455007115405c05105701c455007115405c05105701c455007115405ced01e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20aef6007115405c05105701c455007115405c05105701c455007115405c05105701c455007115405c0510577b80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab3d405c05105701c455007115405c05105701c455007115405c05105701c455007115405c05105701c4d51e20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e26a0f105701c455007115405c05105701c455007115405c05105701c455007115405c05105701c4550071b50788ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b80a20ae0288ab00e22a80b8da03c455007115405c05105701c455007115405c05105701c455007115405c05105701c455007115405ced01e2ba00e11611bcf7d4b4410000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w1h256c0d16.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 3,'mode' => 0,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d494844520000000100000100100000000007c59f0700000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000194944415428cf639839938178949646021a3579d4e4416f3200195c01dad68ec4880000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 16,'height' => 256},'w1h256c6d16.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],'scanline_width' => 9,'mode' => 6,'scanline_delta' => 8,'data' => '89504e470d0a1a0a0000000d494844520000000100000100100600000022aec0db00000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e0000003d4944415448c7edd0b10d00300c02412b2b312d433193d358d92072f35474a02bdbb6bb4f4d764a92245bebaf4892b47e030d34d040030d34d0f8a9710110943c61430975d60000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 16,'height' => 256},'w1h1c0d16.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 3,'mode' => 0,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d49484452000000010000000110000000006aee471600000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000b4944415408d7639839130001ce0133cf5345de0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w512h256c3d8.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 513,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000803000000f24e3e5500000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e0000026f4944415478daedd221720340100341e7ff9f0e36dd039a2ab7681381f97cbef7f73dfa539a3d4605400540054005400540054005400540054005400540054005400fda7942179a3d4605400540054005400540054005400540054005400540054005405f03c83ca17bcd1ea302a002a002a002a002a002a002a002a002a002a002a002a002a007ed3ca10bcd1ea302a002a002a002a002a002a002a002a002a002a002a002a002a0af01649ed0bd668f5101500150015001500150015001500150015001500150015001d083769ed085668f5101500150015001500150015001500150015001500150015001d0d700324fe85eb3c7a800a800a800a800a800a800a800a800a800a800a800a800a800e8413b4fe842b3c7a800a800a800a800a800a800a800a800a800a800a800a800a800e86b00992774afd9635400540054005400540054005400540054005400540054005400f4a09d2774a1d9635400540054005400540054005400540054005400540054005400f43580cc13bad7ec312a002a002a002a002a002a002a002a002a002a002a002a002a007ad0ce13bad0ec312a002a002a002a002a002a002a002a002a002a002a002a002a00fa1a40e609dd6bf61815001500150015001500150015001500150015001500150015003d68e7095d68f61815001500150015001500150015001500150015001500150015007d0d20f384ee357b8c0a800a800a800a800a800a800a800a800a800a800a800a800a801eb4f3842e347b8c0a800a800a800a800a800a800a800a800a800a800a800a800a80be06907942f79a3d4605400540054005400540054005400540054005400540054005400fda794217fa0f98630002997e96c30000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w1h256c4d8.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],'scanline_width' => 3,'mode' => 4,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d4948445200000001000001000804000000d837d41300000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000214944415428cf6398f99f89818158749668950c0c4cc6a4281e3579d4e48130190038770c64763222030000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w512h1c0d8.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 513,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000002000000000108000000008dd049aa00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000134944415428cf6398890ad250c1a8ec709705000ddeff34a61d99460000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w512h1c6d8.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 2049,'mode' => 6,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d4948445200000200000000010806000000a8bb167600000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e0000002e4944415448c7639c3973e67f0632c1d9b367c9d5ca606c6c4cb6de517b47ed1db577d4de517b47ed1db597327b019fbe35cc79f8e2ff0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w1h1c3d4.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010403000000ed3bd9ba00000003504c54459999997ce8a41600000001624b47440088051d48000000097048597300000048000000480046c96b3e0000000a4944415408d76360000000020001e221bc330000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 4,'height' => 1},'w1h1c2d8.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 4,'mode' => 2,'scanline_delta' => 3,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010802000000907753de00000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e0000000c4944415408d7639839732600039a01ccde467b450000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w512h256c0d1.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 65,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000100000000edebf3ca00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e000000514944415478daedcc21010000000220ff9fd6115618407a8a40201008040281402010080402814020100804028140201008040281402010080402814020100804028140201008040281402010080402c167ae37c3b2567e75fc0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 1,'height' => 256},'w1h1c3d1.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000001010300000025db56ca00000003504c54459999997ce8a41600000001624b47440088051d48000000097048597300000048000000480046c96b3e0000000a4944415408d76360000000020001e221bc330000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 1,'height' => 1},'w512h256c3d4.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 257,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000020000000100040300000037bed35400000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000001754944415478daedd9b109c0300c04406b8364ff6553f8c11b38029d2a0b37e2caffb5f6d4bb67e8dae61000000000000000000000000000007067cde3c9c7b8b5cd210000000000000000000000000000e02640a6f231746d73080000000000000000000000000000d00e0b44000000000000000000000000000080765820020000000000000000000000000000b4c302110000000000000000000000000000a01d1688000000000000000000000000000000edb040040000000000000000000000000000688705220000000000000000000000000000403b2c1001000000000000000000d0e610000000fc0390a97c0c5ddb1c020000000000000000000000000000b4c302110000000000000000000000000000a01d1688000000000000000000000000000000edb040040000000000000000000000000000688705220000000000000000000000000000403b2c10010000000000000000000000000000da6181080000000000000000000000000000d00e9ff5038dbd790977cd12910000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 4,'height' => 256},'w512h1c4d8.png' => {'width' => 512,'original_filters' => [1],'scanline_width' => 1025,'mode' => 4,'scanline_delta' => 2,'data' => '89504e470d0a1a0a0000000d494844520000020000000001080400000002b2defd00000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000001d4944415438cb639cf99f010f388b4f92c1986154efa8de51bd43592f0025c1129a6aa70c2f0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 8,'height' => 1},'w1h1c2d16.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 7,'mode' => 2,'scanline_delta' => 6,'data' => '89504e470d0a1a0a0000000d4948445200000001000000011002000000c0e78f9d00000006624b474499999999999904e68e77000000097048597300000048000000480046c96b3e0000000f4944415408d763983973e6cc9933010c940397f31041150000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h1c4d16.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 5,'mode' => 4,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d4948445200000001000000011004000000e58cd04100000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000d4944415408d7639839f3ff7f000731033172230d330000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 16,'height' => 1},'w1h256c2d8.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3],'scanline_width' => 4,'mode' => 2,'scanline_delta' => 3,'data' => '89504e470d0a1a0a0000000d4948445200000001000001000802000000fd5c8bcf00000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e000000264944415428cf6398397326130303033998594a4a8a5cbd4cc6c6c6a3f68eda3b6aefc0da0b0065310b59f905b3460000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w1h256c3d8.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d494844520000000100000100080300000045e0ecaa00000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000134944415418d36360c00b18f1c251bd435e2f007a79007a7899e9b50000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w512h256c0d16.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 1025,'mode' => 0,'scanline_delta' => 2,'data' => '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','depth' => 16,'height' => 256},'w1h256c6d8.png' => {'width' => 1,'original_filters' => [0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],'scanline_width' => 5,'mode' => 6,'scanline_delta' => 4,'data' => '89504e470d0a1a0a0000000d4948445200000001000001000806000000723e1c9800000006624b47440099009900995e445681000000097048597300000048000000480046c96b3e000000314944415438cb63983973e67f2606060606ca89b367cf52c11406060606266363636a1935eaaa51578dba6ad455d85d05001fca1f3091103aa30000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 8,'height' => 256},'w512h256c3d1.png' => {'width' => 512,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 65,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000200000001000103000000ff5e5c2400000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000954944415478daedd5b10d83000c4451238a948cc0288c4646cb28198192026166401446d62baf79e5fd88218ff8e41673fe62cdfb130000bc05c833c6dc63ca7f2cf9bd3f0100c06b80fa43010000ea0c0000d41900680ad41f0a000050670000a0ce004053a0fe500000803a0300007506009a02f587020000d4190000a83300d014a83f140000a0ce0000409d0180a6c0d33fb800a31cd86a64b64e280000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31342b30313a30303e903c180000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31342b30313a30304fcd84a40000000049454e44ae426082','depth' => 1,'height' => 256},'w1h256c0d1.png' => {'width' => 1,'original_filters' => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000000010000010001000000005a45213500000002624b47440000aa8d2332000000097048597300000048000000480046c96b3e0000000f4944415418d36368601885231802000980800106ad33460000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 1,'height' => 256},'w512h1c3d4.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 257,'mode' => 3,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000002000000000104030000005a950b4500000006504c5445999999666666587caad500000001624b47440088051d48000000097048597300000048000000480046c96b3e000000114944415418d36360800046410818715c00e58a07f9ae1ecb720000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 4,'height' => 1},'w512h1c0d4.png' => {'width' => 512,'original_filters' => [0],'scanline_width' => 257,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d49484452000002000000000104000000004820a4ab00000002624b47440009d3519b96000000097048597300000048000000480046c96b3e000000114944415418d363980901d3d22060c47101243c8119baafa73a0000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 4,'height' => 1},'w1h1c0d4.png' => {'width' => 1,'original_filters' => [0],'scanline_width' => 2,'mode' => 0,'scanline_delta' => 1,'data' => '89504e470d0a1a0a0000000d4948445200000001000000010400000000ff8e765400000002624b47440009d3519b96000000097048597300000048000000480046c96b3e0000000a4944415408d76398000000920091b8ace3390000002574455874646174653a63726561746500323031312d30332d30365430333a35313a31332b30313a3030fb3702960000002574455874646174653a6d6f6469667900323031312d30332d30365430333a35313a31332b30313a30308a6aba2a0000000049454e44ae426082','depth' => 4,'height' => 1}};

foreach my $name (keys %$test) {

  my $raw = pack 'H*', $test->{$name}{data};
  open my $handler, '<', \$raw;
  my $re = Image::PNG::Rewriter->new(handle => $handler);
  my $x = $test->{$name};

  is($x->{height}, $re->height);
  is($x->{width}, $re->width);
  is($x->{depth}, $re->depth);
  is($x->{mode}, $re->color_mode);
  is($x->{scanline_width}, $re->scanline_width);
  is($x->{scanline_delta}, $re->scanline_delta);
  is_deeply($x->{original_filters}, [ $re->original_filters ]);
  $re->refilter((0) x $re->height);
  my ($de, $in) = $re->refilter($re->original_filters);
  is($in, $re->original_inflated);
}
