#!perl

# ########################################################################## #
# Title:         Data stream importer
# Creation date: 2007-03-05
# Author:        Michael Zedeler
# Description:   Generates data stream data
#                Data Stream class
# File:          $Source: /data/cvs/lib/DSlib/lib/DS/Importer.pm,v $
# Repository:    kronhjorten
# State:         $State: Exp $
# Documentation: inline
# Recepient:     -
# #TODO Importers should not by default be constructed with an explicit typespec, since this may be derived from the data source
# ########################################################################## #

package DS::Importer;

use base qw{ DS::Source };

use strict;
use Carp qw{ croak cluck };
require Carp::Assert;

our ($VERSION) = $DS::VERSION;
our ($REVISION) = '$Revision: 1.1 $' =~ /(\d+\.\d+)/;

#TODO Add $row to to constructor

# This method fetches 
sub execute {
    my( $self, $rows ) = @_;
    $rows = -1 unless $rows;
    while( $rows-- != 0 ) {
        my $result = $self->_fetch();
        $self->pass_row( $result );
        # Exit if we just passed end of stream.
        last if not defined( $result );
    }
}

# Fetches one row from underlying data source and returns it to caller.
# When end of data source has been reached, this method MUST return undef on
# all subsequent calls.
# Note that this method doesn't pass anything on to any attached
# target.
# When writing importers, this is the method you will want to override.
# This method is private.
sub _fetch {
    croak("This method must be overridden.");
}

1;
