/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.PlacementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlacementStrategy
implements PlacementStrategy {
    private final StringBounder stringBounder;
    private final Map<TextBlock, Dimension2D> dimensions = new LinkedHashMap<TextBlock, Dimension2D>();

    public AbstractPlacementStrategy(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    @Override
    public void add(TextBlock textBlock) {
        this.dimensions.put(textBlock, textBlock.calculateDimension(this.stringBounder));
    }

    protected Map<TextBlock, Dimension2D> getDimensions() {
        return this.dimensions;
    }

    protected double getSumWidth() {
        return this.getSumWidth(this.dimensions.values().iterator());
    }

    protected double getSumHeight() {
        return this.getSumHeight(this.dimensions.values().iterator());
    }

    protected double getMaxHeight() {
        return this.getMaxHeight(this.dimensions.values().iterator());
    }

    protected double getMaxWidth() {
        return this.getMaxWidth(this.dimensions.values().iterator());
    }

    protected double getSumWidth(Iterator<Dimension2D> iterator) {
        double d = 0.0;
        while (iterator.hasNext()) {
            d += iterator.next().getWidth();
        }
        return d;
    }

    protected double getSumHeight(Iterator<Dimension2D> iterator) {
        double d = 0.0;
        while (iterator.hasNext()) {
            d += iterator.next().getHeight();
        }
        return d;
    }

    protected double getMaxWidth(Iterator<Dimension2D> iterator) {
        double d = 0.0;
        while (iterator.hasNext()) {
            d = Math.max(d, iterator.next().getWidth());
        }
        return d;
    }

    protected double getMaxHeight(Iterator<Dimension2D> iterator) {
        double d = 0.0;
        while (iterator.hasNext()) {
            d = Math.max(d, iterator.next().getHeight());
        }
        return d;
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }
}

