use strict;
use Test;
use Config::IniFiles;

BEGIN { plan tests => 4 }

# Test 1
# Loading from a file
my $ini = new Config::IniFiles -file => "t/test.ini";
$ini->SetFileName("t/test01.ini");
ok($ini);

# Test 2
# Reading a value
my $value = $ini->val('test2', 'five') || '';
ok ($value eq 'value5');

# Test 3
# Creating a new value
$ini->newval('test2', 'seven', 'value7');
$ini->RewriteConfig;
$ini->ReadConfig;
$value='';
$value = $ini->val('test2', 'seven');
ok ($value eq 'value7');

# Test 4
# Deleting a value
$ini->delval('test2', 'seven');
$ini->RewriteConfig;
$ini->ReadConfig;
$value='';
$value = $ini->val('test2', 'seven');
ok (! defined ($value));
