#!/usr/bin/env perl

use strict;
use warnings;

BEGIN {
	$| = 1;
}

use Test::More tests => 25;

use Games::Sudoku::PatternSolver qw( solve $VERBOSE $MAX_SOLUTIONS $LOOSE_MODE $USE_LOGIC );

$VERBOSE = 0;
$MAX_SOLUTIONS = 0;
$LOOSE_MODE = 0;
$USE_LOGIC = 1; 

my $n = 0;
while (<DATA>) {
  chomp;
  my ($sudoku, $sc, $solution) = split /:/ or next;
  $n++;

  my $result = solve($sudoku);

  is($result->{solutionCount}, $sc, "Game $n solution count");
  if ($sc < 2) {
	is($result->{solutions}[0], $solution, "Game $n");
  }
}

__DATA__
2.6.3......1.65.7..471.8.5.5......29..8.194.6...42...1....428..6.93....5.7.....13:1:256734198891265374347198652514683729728519436963427581135942867689371245472856913
..45.21781...9..3....8....46..45.....7.9...128.12.35..4.......935..6.8.7.9.3..62.:1:964532178187694235235817964629451783573986412841273596416728359352169847798345621
59....147...9....8.72....3.7...4.29..2..3.8.68..17..5...5764..9.36..5...1..8....2:1:598326147314957628672481935753648291421539876869172453285764319936215784147893562
9...84.6.6.4..52.7.3..7..8.76...15...53.....1...4.96.31.5.26.9...2.4....8....371.:1:927384165684915237531672489769231548453768921218459673175826394392147856846593712
68.9.5.....3...5.84.21.87.339.72.8.........1..45..69...6.8.4..2..1..2.757...13...:1:687935241913247568452168793396721854278459316145386927569874132831692475724513689
...34...2..6.82.737..1..45..82..5.14....983..67......514.7.....9.5.3..2..3....8.6:1:851347692496582173723169458382675914514298367679413285148726539965834721237951846
6...5.....73..8.2.854.27...2.17..53.4...69..7.8....9...273.1.84.6.54...93.......1:1:612453798973618425854927163291784536435269817786135942527391684168542379349876251
..75..9.4....823.5..16....28...36.7..16..42..43.19..5.54...8....29.71.3.......6.9:1:287513964964782315351649782895236471716854293432197856543968127629471538178325649
8.........59.......76.........978245...653198...412736...591......836.1....724.8.:601
8.........95.......76.........974286...512943...638517...791.6....4237.8...856...:122
8.........59.......67.........728563...691487...534912...976.3....4127.8...853...:91
8.........59.......67.........756238...418796...923415...571.6....8921.7...634...:132
8.........59.......67..........3.265...4.6198......437...753916...891742...624583:13
8.........59.......76.........832765...476198...951243....9.516...6.4982......437:9
8.........95.......67.........472968...913245...856137....9.716...6.8492......583:3
8.........95.......67.........954286...712943...638517...476..5...521.3....8934..:102
.......8...6.8.1..7....3..4.47..5...5..34............53....4..7......9...1.9...6.:633
