use strict;
use warnings;

use Test::More tests=>11;


BEGIN {#1
    use_ok( 'Graph::Dijkstra' ) || print "Bail out!\n";
}

{#tests 2-7

	my $graph = Graph::Dijkstra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	$graph->node('A', 'one');
	$graph->node('B', 'two');
	$graph->node('C', 'three');
	$graph->node('D', 'four');
	$graph->node('E', 'five');
	$graph->node('F', 'six');
	$graph->node('G', 'seven');
	$graph->node('H', 'eight');
	$graph->node('I', 'nine');
	$graph->node('J', 'ten');
	$graph->node('K', 'eleven');
	$graph->node('L', 'twelve');
	$graph->node('M', 'thirteen');
	$graph->node('N', 'fourteen');
	ok( $graph->node('N') eq 'fourteen', "\$graph->node('N') eq 'fourteen'" );
	
	$graph->edge('A','B',4);
	$graph->edge('A','D',3);
	$graph->edge('A','E',7);
	$graph->edge('A','F',5);
	$graph->edge('B','C',7);
	$graph->edge('B','F',2);
	$graph->edge('C','F',3);
	$graph->edge('C','G',5);
	$graph->edge('D','E',5);
	$graph->edge('D','H',5);
	$graph->edge('E','F',3);
  $graph->edge('E','H',2);
  $graph->edge('F','G',4);
  $graph->edge('F','K',5);
  $graph->edge('G','K',2);
  $graph->edge('H','L',6);
  $graph->edge('I','J',2);
  $graph->edge('I','L',4);
  $graph->edge('I','M',7);
  $graph->edge('J','K',9);
  $graph->edge('K','N',6);
  $graph->edge('M','N',3);
	ok( $graph->edge('N','M') == 3, "\$graph->edge('N','M') == 3" );

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('I', \%Solution);
	
	ok( ($solutionCost == 18 and $Solution{count} == 2),"\$graph->farthestNode('I', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('I', 'A', \%Solution);
	
	ok( ($pathCost == 18 and $Solution{edges}->[0]->{target} eq 'L'),"\$graph->shortestPath('I','A', \\\%Solution)");

	my @nodelist = $graph->nodeList();
	ok ( scalar(@nodelist) == 14, '$graph->nodeList() returns 14 elements');
}

{#tests 8-11

	my $graph = Graph::Dijkstra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	$graph->node('A', 'one');
	$graph->node('B', 'two');
	
	$graph->edge('A','B',4);

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('A', \%Solution);
	
	ok( ($solutionCost == 4 and $Solution{count} == 1),"\$graph->farthestNode('A', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('A', 'B', \%Solution);
	
	ok( ($pathCost == 4 and $Solution{edges}->[0]->{target} eq 'B'),"\$graph->shortestPath('A','B', \\\%Solution)");

	my @nodelist = $graph->nodeList();
	ok ( scalar(@nodelist) == 2, '$graph->nodeList() returns 2 elements');
}