#!/usr/bin/perl

use warnings;
use strict;

use Test::More qw(
	no_plan
	);

use Math::Geometry::Planar::Offset qw(OffsetPolygon);

my @points = ( # pairs of in/expect
[
	[
		[-12235.037978,-17954.653921],
		[-12235.037978,-17980.151890],
		[-12221.642307,-17979.867462],
		[-12221.642307,-17962.024550],
		[-12180.142307,-17960.739087],
		[-12180.142307,-17978.986297],
		[-12110.606734,-17977.509856],
		[-12110.606734,-17951.634453]
	],
	[
		[-12233.517978, -17956.1374839],
		[-12233.517978, -17978.5992735045],
		[-12223.162307, -17978.3793933065],
		[-12223.162307, -17960.5509030101],
		[-12178.622307, -17959.1712759735],
		[-12178.622307, -17977.4336804146],
		[-12112.126734, -17976.0217873926],
		[-12112.126734, -17953.1917850147],
	],
],
[
	[
		[-12233.517978, -17956.1374839],
		[-12233.517978, -17978.5992735045],
		[-12223.162307, -17978.3793933065],
		[-12223.162307, -17960.5509030101],
		[-12178.622307, -17959.1712759735],
		[-12178.622307, -17977.4336804146],
		[-12112.126734, -17976.0217873926],
		[-12112.126734, -17953.1917850147],
	],
	[
		[-12231.997978, -17957.6210468],
		[-12231.997978, -17977.046657009],
		[-12224.682307, -17976.891324613],
		[-12224.682307, -17959.0772560202],
		[-12177.102307, -17957.603464947],
		[-12177.102307, -17975.8810638292],
		[-12113.646734, -17974.5337187852],
		[-12113.646734, -17954.7491170294],
	],
],
); # end test points

my $dist = 1.52;

foreach my $pair (@points) {
	my $copy = [map({[@$_]} @{$pair->[0]})];
	my @polys = OffsetPolygon($copy, $dist);
	is_deeply($copy, $pair->[0], 'unmodified');
	ok(scalar(@polys) == 1, 'no splits');
	my $poly = $polys[0];
	if($pair->[1]) {
		# XXX numeric match likely to fail on some platforms
		# (namely 64bit, etc) -- send patches
		is_deeply($poly, $pair->[1], 'match expected');
	}
	else {
		if((-t STDOUT) and defined($ENV{DEBUG}) and (-e 'tools/show_me')) {
			# sounds like me running this manually
			my @show = map(
				{join(" ", map({'[' . join(', ', @$_) . '],'} @$_))}
				$copy, $poly);
			system($^X, 'tools/show_me', @show) and die;
			
		}
		warn join("\n", map({'[' . join(', ', @$_) . '],'} @$poly)), "\n";
	}
}

# vim:ts=4:sw=4:noet
