# Generated by default/object.tt
package Paws::Lightsail::CacheSettings;
  use Moose;
  has AllowedHTTPMethods => (is => 'ro', isa => 'Str', request_name => 'allowedHTTPMethods', traits => ['NameInRequest']);
  has CachedHTTPMethods => (is => 'ro', isa => 'Str', request_name => 'cachedHTTPMethods', traits => ['NameInRequest']);
  has DefaultTTL => (is => 'ro', isa => 'Int', request_name => 'defaultTTL', traits => ['NameInRequest']);
  has ForwardedCookies => (is => 'ro', isa => 'Paws::Lightsail::CookieObject', request_name => 'forwardedCookies', traits => ['NameInRequest']);
  has ForwardedHeaders => (is => 'ro', isa => 'Paws::Lightsail::HeaderObject', request_name => 'forwardedHeaders', traits => ['NameInRequest']);
  has ForwardedQueryStrings => (is => 'ro', isa => 'Paws::Lightsail::QueryStringObject', request_name => 'forwardedQueryStrings', traits => ['NameInRequest']);
  has MaximumTTL => (is => 'ro', isa => 'Int', request_name => 'maximumTTL', traits => ['NameInRequest']);
  has MinimumTTL => (is => 'ro', isa => 'Int', request_name => 'minimumTTL', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::CacheSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::CacheSettings object:

  $service_obj->Method(Att1 => { AllowedHTTPMethods => $value, ..., MinimumTTL => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::CacheSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowedHTTPMethods

=head1 DESCRIPTION

Describes the cache settings of an Amazon Lightsail content delivery
network (CDN) distribution.

These settings apply only to your distribution's C<cacheBehaviors>
(including the C<defaultCacheBehavior>) that have a C<behavior> of
C<cache>.

=head1 ATTRIBUTES


=head2 AllowedHTTPMethods => Str

The HTTP methods that are processed and forwarded to the distribution's
origin.

You can specify the following options:

=over

=item *

C<GET,HEAD> - The distribution forwards the C<GET> and C<HEAD> methods.

=item *

C<GET,HEAD,OPTIONS> - The distribution forwards the C<GET>, C<HEAD>,
and C<OPTIONS> methods.

=item *

C<GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE> - The distribution forwards
the C<GET>, C<HEAD>, C<OPTIONS>, C<PUT>, C<PATCH>, C<POST>, and
C<DELETE> methods.

=back

If you specify the third option, you might need to restrict access to
your distribution's origin so users can't perform operations that you
don't want them to. For example, you might not want users to have
permission to delete objects from your origin.


=head2 CachedHTTPMethods => Str

The HTTP method responses that are cached by your distribution.

You can specify the following options:

=over

=item *

C<GET,HEAD> - The distribution caches responses to the C<GET> and
C<HEAD> methods.

=item *

C<GET,HEAD,OPTIONS> - The distribution caches responses to the C<GET>,
C<HEAD>, and C<OPTIONS> methods.

=back



=head2 DefaultTTL => Int

The default amount of time that objects stay in the distribution's
cache before the distribution forwards another request to the origin to
determine whether the content has been updated.

The value specified applies only when the origin does not add HTTP
headers such as C<Cache-Control max-age>, C<Cache-Control s-maxage>,
and C<Expires> to objects.


=head2 ForwardedCookies => L<Paws::Lightsail::CookieObject>

An object that describes the cookies that are forwarded to the origin.
Your content is cached based on the cookies that are forwarded.


=head2 ForwardedHeaders => L<Paws::Lightsail::HeaderObject>

An object that describes the headers that are forwarded to the origin.
Your content is cached based on the headers that are forwarded.


=head2 ForwardedQueryStrings => L<Paws::Lightsail::QueryStringObject>

An object that describes the query strings that are forwarded to the
origin. Your content is cached based on the query strings that are
forwarded.


=head2 MaximumTTL => Int

The maximum amount of time that objects stay in the distribution's
cache before the distribution forwards another request to the origin to
determine whether the object has been updated.

The value specified applies only when the origin adds HTTP headers such
as C<Cache-Control max-age>, C<Cache-Control s-maxage>, and C<Expires>
to objects.


=head2 MinimumTTL => Int

The minimum amount of time that objects stay in the distribution's
cache before the distribution forwards another request to the origin to
determine whether the object has been updated.

A value of C<0> must be specified for C<minimumTTL> if the distribution
is configured to forward all headers to the origin.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

