# Generated by default/object.tt
package Paws::Glue::BooleanColumnStatisticsData;
  use Moose;
  has NumberOfFalses => (is => 'ro', isa => 'Int', required => 1);
  has NumberOfNulls => (is => 'ro', isa => 'Int', required => 1);
  has NumberOfTrues => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::BooleanColumnStatisticsData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::BooleanColumnStatisticsData object:

  $service_obj->Method(Att1 => { NumberOfFalses => $value, ..., NumberOfTrues => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::BooleanColumnStatisticsData object:

  $result = $service_obj->Method(...);
  $result->Att1->NumberOfFalses

=head1 DESCRIPTION

Defines column statistics supported for Boolean data columns.

=head1 ATTRIBUTES


=head2 B<REQUIRED> NumberOfFalses => Int

The number of false values in the column.


=head2 B<REQUIRED> NumberOfNulls => Int

The number of null values in the column.


=head2 B<REQUIRED> NumberOfTrues => Int

The number of true values in the column.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

