use strict;
use warnings FATAL => 'all';

package MarpaX::Java::ClassFile::Struct::BootstrapMethod;
use MarpaX::Java::ClassFile::Util::ArrayStringification qw/arrayStringificator/;
use MarpaX::Java::ClassFile::Struct::_Base
  -tiny => [qw/_constant_pool bootstrap_method_ref num_bootstrap_arguments bootstrap_arguments/],
  '""' => [
           [ sub { 'Bootstrap method#' . $_[0]->bootstrap_method_ref } => sub { $_[0]->_constant_pool->[$_[0]->bootstrap_method_ref] } ],
           [ sub { 'Bootstrap arguments count'                       } => sub { $_[0]->num_bootstrap_arguments } ],
           [ sub { 'Bootstrap arguments'                             } => sub { $_[0]->arrayStringificator($_[0]->bootstrap_arguments) } ]
          ];

# ABSTRACT: bootstrap method

our $VERSION = '0.009'; # VERSION

our $AUTHORITY = 'cpan:JDDPAUSE'; # AUTHORITY

use MarpaX::Java::ClassFile::Struct::_Types qw/U2/;
use Types::Standard qw/ArrayRef/;

has _constant_pool          => ( is => 'rw', required => 1, isa => ArrayRef);
has bootstrap_method_ref    => ( is => 'ro', required => 1, isa => U2 );
has num_bootstrap_arguments => ( is => 'ro', required => 1, isa => U2 );
has bootstrap_arguments     => ( is => 'ro', required => 1, isa => ArrayRef[U2] );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

MarpaX::Java::ClassFile::Struct::BootstrapMethod - bootstrap method

=head1 VERSION

version 0.009

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
