/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.ProxyOutputStream;

public class ClientRequestFilterInterceptor
extends AbstractOutDatabindingInterceptor {
    public ClientRequestFilterInterceptor() {
        super("pre-logical");
    }

    @Override
    public void handleMessage(Message outMessage) throws Fault {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(outMessage);
        if (pf == null) {
            return;
        }
        ProxyOutputStream pos = new ProxyOutputStream();
        outMessage.setContent(OutputStream.class, pos);
        outMessage.setContent(ProxyOutputStream.class, pos);
        List<ProviderInfo<ClientRequestFilter>> filters = pf.getClientRequestFilters();
        if (!filters.isEmpty()) {
            Exchange exchange = outMessage.getExchange();
            ClientRequestContextImpl context = new ClientRequestContextImpl(outMessage, false);
            for (ProviderInfo<ClientRequestFilter> filter : filters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, outMessage);
                try {
                    filter.getProvider().filter(context);
                    Map<String, List<Object>> headers = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS));
                    HttpUtils.convertHeaderValuesToString(headers, false);
                    Response response = outMessage.getExchange().get(Response.class);
                    if (response == null) continue;
                    outMessage.getInterceptorChain().abort();
                    MessageImpl inMessage = new MessageImpl();
                    inMessage.setExchange(exchange);
                    inMessage.put(Message.RESPONSE_CODE, response.getStatus());
                    inMessage.put(Message.PROTOCOL_HEADERS, response.getMetadata());
                    exchange.setInMessage(inMessage);
                    MessageObserver observer = exchange.get(MessageObserver.class);
                    observer.onMessage(inMessage);
                    return;
                }
                catch (IOException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }
    }
}

