/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;
import org.apache.sis.internal.jdk8.IntSupplier;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.ConcatenatedVector;
import org.apache.sis.math.PackedVector;
import org.apache.sis.math.SequenceVector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class Vector
extends AbstractList<Number>
implements RandomAccess {
    public static Vector create(Object object, boolean bl) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return ArrayVector.newInstance(object, bl);
        }
        if (object instanceof Vector) {
            return (Vector)object;
        }
        throw new IllegalArgumentException(Errors.format((short)42, "array", object.getClass()));
    }

    public static Vector createForDecimal(float[] fArray) {
        return fArray != null ? new ArrayVector.Decimal(fArray) : null;
    }

    public static Vector createSequence(Number number, Number number2, int n) {
        Class<? extends Number> clazz = Numbers.widestClass(number, number2);
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass(number.doubleValue() + number2.doubleValue() * (double)(n - 1)));
        return Vector.createSequence(clazz, number, number2, n);
    }

    static Vector createSequence(Class<? extends Number> clazz, Number number, Number number2, int n) {
        byte by = Numbers.getEnumConstant(clazz);
        if (by >= 3 && by <= 6) {
            return new SequenceVector.Longs(clazz, number, number2, n);
        }
        return new SequenceVector.Doubles(clazz, number, number2, n);
    }

    protected Vector() {
    }

    public abstract Class<? extends Number> getElementType();

    public boolean isInteger() {
        if (!Numbers.isInteger(this.getElementType())) {
            int n = this.size();
            while (--n >= 0) {
                double d = this.doubleValue(n);
                if (d == Math.floor(d)) continue;
                return false;
            }
        }
        return true;
    }

    public abstract boolean isUnsigned();

    @Override
    public abstract int size();

    public abstract boolean isNaN(int var1);

    public abstract double doubleValue(int var1);

    public abstract float floatValue(int var1);

    public long longValue(int n) {
        double d = this.doubleValue(n);
        long l = Math.round(d);
        if (Math.abs((double)l - d) <= 0.5) {
            return l;
        }
        throw this.canNotConvert(n, Long.TYPE);
    }

    public int intValue(int n) {
        long l = this.longValue(n);
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        throw this.canNotConvert(n, Integer.TYPE);
    }

    public short shortValue(int n) {
        long l = this.longValue(n);
        if (l >= -32768L && l <= 32767L) {
            return (short)l;
        }
        throw this.canNotConvert(n, Short.TYPE);
    }

    public byte byteValue(int n) {
        long l = this.longValue(n);
        if (l >= -128L && l <= 127L) {
            return (byte)l;
        }
        throw this.canNotConvert(n, Byte.TYPE);
    }

    private ArithmeticException canNotConvert(int n, Class<?> clazz) {
        return new ArithmeticException(Errors.format((short)8, this.stringValue(n), clazz));
    }

    public abstract String stringValue(int var1);

    @Override
    public abstract Number get(int var1);

    @Override
    public abstract Number set(int var1, Number var2);

    final long subtract(long l, long l2) {
        long l3 = l - l2;
        if ((((long)(this.isUnsigned() ? JDK8.compareUnsigned(l, l2) : Long.compare(l, l2)) ^ l3) & Long.MIN_VALUE) != 0L) {
            throw new ArithmeticException();
        }
        return l3;
    }

    public Number increment(double d) {
        ArgumentChecks.ensurePositive("tolerance", d);
        int n = this.size();
        if (n >= 2) {
            try {
                byte by = Numbers.getEnumConstant(this.getElementType());
                if (by >= 3 && by <= 6 && d < 1.0) {
                    long l = this.longValue(--n);
                    long l2 = this.longValue(--n);
                    long l3 = this.subtract(l, l2);
                    while (n != 0) {
                        if (l2 - (l2 = this.longValue(--n)) == l3) continue;
                        return null;
                    }
                    switch (by) {
                        case 3: {
                            if (l3 >= -128L && l3 <= 127L) {
                                return (byte)l3;
                            }
                        }
                        case 4: {
                            if (l3 >= -32768L && l3 <= 32767L) {
                                return (short)l3;
                            }
                        }
                        case 5: {
                            if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) break;
                            return (int)l3;
                        }
                    }
                    return l3;
                }
                if (by >= 7 && by <= 8) {
                    float f;
                    double d2 = this.doubleValue(0);
                    double d3 = (this.doubleValue(--n) - d2) / (double)n;
                    while (n >= 1) {
                        if (Math.abs(d2 + d3 * (double)n - this.doubleValue(n--)) <= d) continue;
                        return null;
                    }
                    if (by == 7 && (double)(f = (float)d3) == d3) {
                        return Float.valueOf(f);
                    }
                    return d3;
                }
            }
            catch (ArithmeticException arithmeticException) {
                this.warning("increment", arithmeticException);
            }
        }
        return null;
    }

    public NumberRange<?> range() {
        return this.range(null, this.size());
    }

    NumberRange<?> range(IntSupplier intSupplier, int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        while (--n >= 0) {
            double d3 = this.doubleValue(intSupplier != null ? intSupplier.getAsInt() : n);
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return NumberRange.create(d, true, d2, true);
    }

    public final Vector subList(int n, int n2) {
        return this.subSampling(n, 1, n2 - n);
    }

    public Vector subSampling(int n, int n2, int n3) {
        if (n2 == 1 && n == 0 && n3 == this.size()) {
            return this;
        }
        return this.createSubSampling(n, n2, n3);
    }

    Vector createSubSampling(int n, int n2, int n3) {
        return new SubSampling(n, n2, n3);
    }

    Vector backingVector() {
        return this;
    }

    int[] toBacking(int[] nArray) {
        nArray = (int[])nArray.clone();
        int n = this.size();
        for (int n2 : nArray) {
            ArgumentChecks.ensureValidIndex(n, n2);
        }
        return nArray;
    }

    public Vector pick(int ... nArray) {
        int n;
        int n2;
        nArray = this.toBacking(nArray);
        switch (nArray.length) {
            case 0: {
                n2 = 0;
                n = 1;
                break;
            }
            case 1: {
                n2 = nArray[0];
                n = 1;
                break;
            }
            default: {
                n2 = nArray[0];
                int n3 = nArray[1];
                n = n3 - n2;
                for (int i = 2; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    if (n4 - n3 != n) {
                        Vector vector = this.backingVector();
                        vector.getClass();
                        return vector.new Pick(nArray);
                    }
                    n3 = n4;
                }
            }
        }
        return this.subSampling(n2, n, nArray.length);
    }

    static void ensureValid(int n, int n2, int n3) {
        if (n3 < 0) {
            Object object;
            Object object2;
            short s;
            if (n2 == 1) {
                s = 60;
                object2 = n;
                object = n + n3;
            } else {
                s = 45;
                object2 = "range";
                object = "[" + n + ':' + n2 + ':' + (n + n2 * n3) + ']';
            }
            throw new IllegalArgumentException(Errors.format(s, object2, object));
        }
    }

    public Vector concatenate(Vector vector) {
        if (vector.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return vector;
        }
        return this.createConcatenate(vector);
    }

    Vector createConcatenate(Vector vector) {
        return new ConcatenatedVector(this, vector);
    }

    public final Vector reverse() {
        int n = this.size();
        return n > 1 ? this.subSampling(n - 1, -1, n) : this;
    }

    public Vector compress(double d) {
        int n = this.size();
        Number number = this.increment(d);
        if (number != null) {
            return Vector.createSequence(this.getElementType(), this.get(0), number, n);
        }
        int n2 = 0;
        do {
            if (n2 < n) continue;
            Double d2 = Numerics.valueOf(Double.NaN);
            return new SequenceVector.Doubles(this.getElementType(), d2, d2, n);
        } while (this.isNaN(n2++));
        NumberRange<?> numberRange = this.range();
        if (numberRange != null && !numberRange.isEmpty()) {
            Vector vector;
            boolean bl;
            Number number2 = (Number)numberRange.getMinValue();
            Number number3 = (Number)numberRange.getMaxValue();
            boolean bl2 = bl = number2.doubleValue() >= -9.223372036854776E18 && number3.doubleValue() <= 9.223372036854776E18 && this.isInteger();
            if (bl) {
                vector = PackedVector.compress(this, number2.longValue(), number3.longValue());
                if (vector == null) {
                    vector = ArrayVector.compress(this, number2.longValue(), number3.longValue());
                }
            } else {
                vector = ArrayVector.compress(this, d);
            }
            if (vector != null) {
                return vector;
            }
        }
        return this;
    }

    final void warning(String string, RuntimeException runtimeException) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.math"), Vector.class, string, runtimeException);
    }

    public double[] doubleValues() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.doubleValue(i);
        }
        return dArray;
    }

    public float[] floatValues() {
        float[] fArray = new float[this.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.floatValue(i);
        }
        return fArray;
    }

    @Override
    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "[";
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string).append(this.stringValue(i));
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    private final class Pick
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 6574040261355090760L;
        private final int[] indices;

        Pick(int[] nArray) {
            this.indices = nArray;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        @Override
        int[] toBacking(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.indices[nArray[i]];
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public int size() {
            return this.indices.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.indices[n]);
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.indices[n]);
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.indices[n]);
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.indices[n]);
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.indices[n]);
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.indices[n]);
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.indices[n]);
        }

        @Override
        public String stringValue(int n) {
            return Vector.this.stringValue(this.indices[n]);
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.indices[n]);
        }

        @Override
        public Number set(int n, Number number) {
            Number number2 = Vector.this.set(this.indices[n], number);
            ++this.modCount;
            return number2;
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            Pick.ensureValid(n, n2, n3);
            int[] nArray = new int[n3];
            if (n2 == 1) {
                System.arraycopy(this.indices, n, nArray, 0, n3);
            } else {
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.indices[n];
                    n += n2;
                }
            }
            return Vector.this.pick(nArray);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof Pick && vector.backingVector() == Vector.this) {
                int[] nArray = ((Pick)vector).indices;
                int[] nArray2 = Arrays.copyOf(this.indices, this.indices.length + nArray.length);
                System.arraycopy(nArray, 0, nArray2, this.indices.length, nArray.length);
                return Vector.this.pick(nArray2);
            }
            return super.createConcatenate(vector);
        }

        @Override
        NumberRange<?> range(final IntSupplier intSupplier, int n) {
            if (intSupplier != null) {
                return Vector.this.range(new IntSupplier(){

                    @Override
                    public int getAsInt() {
                        return Pick.this.indices[intSupplier.getAsInt()];
                    }
                }, n);
            }
            return Vector.this.range(new IntSupplier(){
                private int index;

                @Override
                public int getAsInt() {
                    return Pick.this.indices[this.index++];
                }
            }, n);
        }
    }

    private final class SubSampling
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 7641036842053528486L;
        final int first;
        final int step;
        final int length;

        protected SubSampling(int n, int n2, int n3) {
            SubSampling.ensureValid(n, n2, n3);
            this.first = n;
            this.step = n2;
            this.length = n3;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        final int toBacking(int n) {
            ArgumentChecks.ensureValidIndex(this.length, n);
            return n * this.step + this.first;
        }

        @Override
        int[] toBacking(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.toBacking(nArray[i]);
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.toBacking(n));
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.toBacking(n));
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.toBacking(n));
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.toBacking(n));
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.toBacking(n));
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.toBacking(n));
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.toBacking(n));
        }

        @Override
        public String stringValue(int n) {
            return Vector.this.stringValue(this.toBacking(n));
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.toBacking(n));
        }

        @Override
        public Number set(int n, Number number) {
            Number number2 = Vector.this.set(this.toBacking(n), number);
            ++this.modCount;
            return number2;
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            n = this.toBacking(n);
            return Vector.this.subSampling(n, n2 *= this.step, n3);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof SubSampling && vector.backingVector() == Vector.this) {
                SubSampling subSampling = (SubSampling)vector;
                if (subSampling.step == this.step && subSampling.first == this.first + this.step * this.length) {
                    return Vector.this.subSampling(this.first, this.step, this.length + subSampling.length);
                }
            }
            return super.createConcatenate(vector);
        }

        @Override
        NumberRange<?> range(final IntSupplier intSupplier, int n) {
            if (intSupplier != null) {
                return Vector.this.range(new IntSupplier(){

                    @Override
                    public int getAsInt() {
                        return SubSampling.this.toBacking(intSupplier.getAsInt());
                    }
                }, n);
            }
            IntSupplier intSupplier2 = null;
            if (this.first != 0 || this.step != 1) {
                intSupplier2 = new IntSupplier(){
                    private int index;
                    {
                        this.index = SubSampling.this.first;
                    }

                    @Override
                    public int getAsInt() {
                        int n = this.index;
                        this.index += SubSampling.this.step;
                        return n;
                    }
                };
            }
            return Vector.this.range(intSupplier2, n);
        }
    }
}

