use strict;

use Test;
use vars qw($loaded $autoseed
            $num1 $num2 $num3 $num4 $num5 $num6
            $int1 $int2 $int3 $int4 $int5 $int6);

BEGIN { plan tests => 21 }
END   { print "not ok 1\n" unless $loaded }

# Functional interface
# Test the ability to automatically generate a seed, return it, and reproduce
# the same series of random number by specifying this seed manually.

use Math::Random::MT::Perl qw(srand rand irand);
ok($loaded = 1);

# Generate a series of 6 random numbers using an autogenerated seed
ok($autoseed = srand());
ok($num1 = rand());
ok($num2 = rand());
ok($num3 = rand());
ok($int1 = irand());
ok($int2 = irand());
ok($int3 = irand());

# Generate a series of 6 random numbers the same seed value but manually specified
ok(srand($autoseed));
ok($num4 = rand());
ok($num5 = rand());
ok($num6 = rand());
ok($int4 = irand());
ok($int5 = irand());
ok($int6 = irand());

# Both series of number should be the same
ok($num1 == $num4);
ok($num2 == $num5);
ok($num3 == $num6);
ok($int1 == $int4);
ok($int2 == $int5);
ok($int3 == $int6);
