#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::PaidStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PaidStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::PaidStatusCodeType

=head1 DESCRIPTION

Specifies the payment status of a transaction, as
seen by the buyer and seller.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 NotPaid

The buyer has not completed checkout, but has not paid through PayPal or
PaisaPay (but please also see the documentation for PaymentHoldStatus and its applicable values).
The buyer might have paid using another method, but the payment
might not have been received or cleared.
Important: Please see the documentation for PaymentHoldStatus and its applicable values. 
PaymentHoldStatus contains the current status of a hold on a PayPal payment.



=cut


use constant NotPaid => scalar('NotPaid');


=head2 BuyerHasNotCompletedCheckout

The buyer has not completed the checkout process and so has not made payment.



=cut


use constant BuyerHasNotCompletedCheckout => scalar('BuyerHasNotCompletedCheckout');


=head2 PaymentPendingWithPayPal

The buyer has made a PayPal payment, but the seller has not yet received it.



=cut


use constant PaymentPendingWithPayPal => scalar('PaymentPendingWithPayPal');


=head2 PaidWithPayPal

The buyer has made a PayPal payment, and the payment is complete.
But please also see the documentation for PaymentHoldStatus and its applicable values. 
PaymentHoldStatus contains the current status of a hold on a PayPal payment.



=cut


use constant PaidWithPayPal => scalar('PaidWithPayPal');


=head2 MarkedAsPaid

The transaction is marked as paid by either buyer or seller.



=cut


use constant MarkedAsPaid => scalar('MarkedAsPaid');


=head2 PaymentPendingWithEscrow

The buyer has made an escrow payment, but the seller has not yet received it.



=cut


use constant PaymentPendingWithEscrow => scalar('PaymentPendingWithEscrow');


=head2 PaidWithEscrow

The buyer has made an escrow payment, and the seller has received payment.



=cut


use constant PaidWithEscrow => scalar('PaidWithEscrow');


=head2 EscrowPaymentCancelled

The buyer has made an escrow payment, but has cancelled the payment.



=cut


use constant EscrowPaymentCancelled => scalar('EscrowPaymentCancelled');


=head2 PaymentPendingWithPaisaPay

The buyer has paid with PaisaPay, but the payment is still being processed.
The seller has not yet received payment.



=cut


use constant PaymentPendingWithPaisaPay => scalar('PaymentPendingWithPaisaPay');


=head2 PaidWithPaisaPay

The buyer has paid with PaisaPay, and the payment is complete.



=cut


use constant PaidWithPaisaPay => scalar('PaidWithPaisaPay');


=head2 PaymentPending

The buyer has made a payment other than PayPal, escrow, or PaisaPay, but the
payment is still being processed.



=cut


use constant PaymentPending => scalar('PaymentPending');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
